/*
 * Decompiled with CFR 0.152.
 */
package reactor.core;

import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

@FunctionalInterface
public interface Scannable {
    public static Scannable from(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Scannable) {
            return (Scannable)o;
        }
        return Attr.UNAVAILABLE_SCAN;
    }

    default public Stream<? extends Scannable> actuals() {
        return Attr.recurse(this, Attr.ACTUAL);
    }

    default public Stream<? extends Scannable> inners() {
        return Stream.empty();
    }

    default public boolean isScanAvailable() {
        return true;
    }

    default public Stream<? extends Scannable> parents() {
        return Attr.recurse(this, Attr.PARENT);
    }

    public Object scan(Attr var1);

    default public <T> T scan(Attr key, Class<T> type) {
        Objects.requireNonNull(type, "type");
        Object v = this.scan(key);
        if (v == null || !type.isAssignableFrom(v.getClass())) {
            return null;
        }
        Object r = v;
        return (T)r;
    }

    default public <T> T scanOrDefault(Attr key, T defaultValue) {
        Object v = this.scan(key);
        if (v == null) {
            return defaultValue;
        }
        return (T)v;
    }

    public static enum Attr {
        PARENT,
        DELAY_ERROR,
        PREFETCH,
        CAPACITY,
        ACTUAL,
        ERROR,
        BUFFERED,
        REQUESTED_FROM_DOWNSTREAM,
        CANCELLED,
        TERMINATED;

        static final Scannable UNAVAILABLE_SCAN;

        static Stream<? extends Scannable> recurse(Scannable _s, final Attr key) {
            final Scannable s = Scannable.from(_s.scan(key));
            if (s == null) {
                return Stream.empty();
            }
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new Iterator<Scannable>(){
                Scannable c;
                {
                    this.c = s;
                }

                @Override
                public boolean hasNext() {
                    return this.c != null;
                }

                @Override
                public Scannable next() {
                    Scannable _c = this.c;
                    this.c = Scannable.from(this.c.scan(key));
                    return _c;
                }
            }, 0), false);
        }

        static {
            UNAVAILABLE_SCAN = new Scannable(){

                @Override
                public Object scan(Attr key) {
                    return null;
                }

                @Override
                public boolean isScanAvailable() {
                    return false;
                }
            };
        }
    }
}

