/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.ArrayDeque;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.reactivestreams.Processor;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Disposable;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.Operators;
import reactor.core.publisher.UnicastProcessor;

final class FluxWindow<T>
extends FluxSource<T, Flux<T>> {
    final int size;
    final int skip;
    final Supplier<? extends Queue<T>> processorQueueSupplier;
    final Supplier<? extends Queue<UnicastProcessor<T>>> overflowQueueSupplier;

    FluxWindow(Flux<? extends T> source, int size, Supplier<? extends Queue<T>> processorQueueSupplier) {
        super(source);
        if (size <= 0) {
            throw new IllegalArgumentException("size > 0 required but it was " + size);
        }
        this.size = size;
        this.skip = size;
        this.processorQueueSupplier = Objects.requireNonNull(processorQueueSupplier, "processorQueueSupplier");
        this.overflowQueueSupplier = null;
    }

    FluxWindow(Flux<? extends T> source, int size, int skip, Supplier<? extends Queue<T>> processorQueueSupplier, Supplier<? extends Queue<UnicastProcessor<T>>> overflowQueueSupplier) {
        super(source);
        if (size <= 0) {
            throw new IllegalArgumentException("size > 0 required but it was " + size);
        }
        if (skip <= 0) {
            throw new IllegalArgumentException("skip > 0 required but it was " + skip);
        }
        this.size = size;
        this.skip = skip;
        this.processorQueueSupplier = Objects.requireNonNull(processorQueueSupplier, "processorQueueSupplier");
        this.overflowQueueSupplier = Objects.requireNonNull(overflowQueueSupplier, "overflowQueueSupplier");
    }

    @Override
    public void subscribe(Subscriber<? super Flux<T>> s) {
        if (this.skip == this.size) {
            this.source.subscribe(new WindowExactSubscriber(s, this.size, this.processorQueueSupplier));
        } else if (this.skip > this.size) {
            this.source.subscribe(new WindowSkipSubscriber(s, this.size, this.skip, this.processorQueueSupplier));
        } else {
            this.source.subscribe(new WindowOverlapSubscriber<T>(s, this.size, this.skip, this.processorQueueSupplier, this.overflowQueueSupplier.get()));
        }
    }

    static final class WindowOverlapSubscriber<T>
    extends ArrayDeque<UnicastProcessor<T>>
    implements Disposable,
    InnerOperator<T, Flux<T>> {
        final Subscriber<? super Flux<T>> actual;
        final Supplier<? extends Queue<T>> processorQueueSupplier;
        final Queue<UnicastProcessor<T>> queue;
        final int size;
        final int skip;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<WindowOverlapSubscriber> WIP = AtomicIntegerFieldUpdater.newUpdater(WindowOverlapSubscriber.class, "wip");
        volatile int once;
        static final AtomicIntegerFieldUpdater<WindowOverlapSubscriber> ONCE = AtomicIntegerFieldUpdater.newUpdater(WindowOverlapSubscriber.class, "once");
        volatile int firstRequest;
        static final AtomicIntegerFieldUpdater<WindowOverlapSubscriber> FIRST_REQUEST = AtomicIntegerFieldUpdater.newUpdater(WindowOverlapSubscriber.class, "firstRequest");
        volatile long requested;
        static final AtomicLongFieldUpdater<WindowOverlapSubscriber> REQUESTED = AtomicLongFieldUpdater.newUpdater(WindowOverlapSubscriber.class, "requested");
        volatile int dw;
        static final AtomicIntegerFieldUpdater<WindowOverlapSubscriber> DW = AtomicIntegerFieldUpdater.newUpdater(WindowOverlapSubscriber.class, "dw");
        int index;
        int produced;
        Subscription s;
        volatile boolean done;
        Throwable error;
        volatile boolean cancelled;

        WindowOverlapSubscriber(Subscriber<? super Flux<T>> actual, int size, int skip, Supplier<? extends Queue<T>> processorQueueSupplier, Queue<UnicastProcessor<T>> overflowQueue) {
            this.actual = actual;
            this.size = size;
            this.skip = skip;
            this.processorQueueSupplier = processorQueueSupplier;
            this.wip = 1;
            this.queue = overflowQueue;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t);
                return;
            }
            int i = this.index;
            if (i == 0 && !this.cancelled) {
                WIP.getAndIncrement(this);
                UnicastProcessor<T> w = new UnicastProcessor<T>(this.processorQueueSupplier.get(), this);
                this.offer(w);
                this.queue.offer(w);
                this.drain();
            }
            ++i;
            for (Processor w : this) {
                w.onNext(t);
            }
            int p = this.produced + 1;
            if (p == this.size) {
                Processor w;
                this.produced = p - this.skip;
                w = (Processor)this.poll();
                if (w != null) {
                    w.onComplete();
                }
            } else {
                this.produced = p;
            }
            this.index = i == this.skip ? 0 : i;
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            this.done = true;
            for (Processor w : this) {
                w.onError(t);
            }
            this.clear();
            this.error = t;
            this.drain();
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            for (Processor w : this) {
                w.onComplete();
            }
            this.clear();
            this.drain();
        }

        void drain() {
            if (DW.getAndIncrement(this) != 0) {
                return;
            }
            Subscriber<? super Flux<T>> a = this.actual;
            Queue<UnicastProcessor<T>> q = this.queue;
            int missed = 1;
            do {
                long e;
                long r = this.requested;
                for (e = 0L; e != r; ++e) {
                    boolean empty;
                    boolean d = this.done;
                    UnicastProcessor<T> t = q.poll();
                    boolean bl = empty = t == null;
                    if (this.checkTerminated(d, empty, a, q)) {
                        return;
                    }
                    if (empty) break;
                    a.onNext(t);
                }
                if (e == r && this.checkTerminated(this.done, q.isEmpty(), a, q)) {
                    return;
                }
                if (e == 0L || r == Long.MAX_VALUE) continue;
                REQUESTED.addAndGet(this, -e);
            } while ((missed = DW.addAndGet(this, -missed)) != 0);
        }

        boolean checkTerminated(boolean d, boolean empty, Subscriber<?> a, Queue<?> q) {
            if (this.cancelled) {
                q.clear();
                return true;
            }
            if (d) {
                Throwable e = this.error;
                if (e != null) {
                    q.clear();
                    a.onError(e);
                    return true;
                }
                if (empty) {
                    a.onComplete();
                    return true;
                }
            }
            return false;
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                Operators.getAndAddCap(REQUESTED, this, n);
                if (this.firstRequest == 0 && FIRST_REQUEST.compareAndSet(this, 0, 1)) {
                    long u = Operators.multiplyCap(this.skip, n - 1L);
                    long v = Operators.addCap(this.size, u);
                    this.s.request(v);
                } else {
                    long u = Operators.multiplyCap(this.skip, n);
                    this.s.request(u);
                }
                this.drain();
            }
        }

        public void cancel() {
            this.cancelled = true;
            if (ONCE.compareAndSet(this, 0, 1)) {
                this.dispose();
            }
        }

        @Override
        public void dispose() {
            if (WIP.decrementAndGet(this) == 0) {
                this.s.cancel();
            }
        }

        @Override
        public Subscriber<? super Flux<T>> actual() {
            return this.actual;
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled || this.done;
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case PARENT: {
                    return this.s;
                }
                case CANCELLED: {
                    return this.cancelled;
                }
                case CAPACITY: {
                    return this.size;
                }
                case TERMINATED: {
                    return this.done;
                }
                case BUFFERED: {
                    return this.queue.size() + this.size();
                }
                case ERROR: {
                    return this.error;
                }
                case REQUESTED_FROM_DOWNSTREAM: {
                    return this.requested;
                }
            }
            return InnerOperator.super.scan(key);
        }

        @Override
        public Stream<? extends Scannable> inners() {
            return Stream.of(this.toArray()).map(Scannable::from);
        }
    }

    static final class WindowSkipSubscriber<T>
    implements Disposable,
    InnerOperator<T, Flux<T>> {
        final Subscriber<? super Flux<T>> actual;
        final Supplier<? extends Queue<T>> processorQueueSupplier;
        final int size;
        final int skip;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<WindowSkipSubscriber> WIP = AtomicIntegerFieldUpdater.newUpdater(WindowSkipSubscriber.class, "wip");
        volatile int once;
        static final AtomicIntegerFieldUpdater<WindowSkipSubscriber> ONCE = AtomicIntegerFieldUpdater.newUpdater(WindowSkipSubscriber.class, "once");
        volatile int firstRequest;
        static final AtomicIntegerFieldUpdater<WindowSkipSubscriber> FIRST_REQUEST = AtomicIntegerFieldUpdater.newUpdater(WindowSkipSubscriber.class, "firstRequest");
        int index;
        Subscription s;
        UnicastProcessor<T> window;
        boolean done;

        WindowSkipSubscriber(Subscriber<? super Flux<T>> actual, int size, int skip, Supplier<? extends Queue<T>> processorQueueSupplier) {
            this.actual = actual;
            this.size = size;
            this.skip = skip;
            this.processorQueueSupplier = processorQueueSupplier;
            this.wip = 1;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t);
                return;
            }
            int i = this.index;
            UnicastProcessor<T> w = this.window;
            if (i == 0) {
                WIP.getAndIncrement(this);
                w = new UnicastProcessor<T>(this.processorQueueSupplier.get(), this);
                this.window = w;
                this.actual.onNext(w);
            }
            ++i;
            if (w != null) {
                w.onNext(t);
            }
            if (i == this.size) {
                this.window = null;
                if (w != null) {
                    w.onComplete();
                }
            }
            this.index = i == this.skip ? 0 : i;
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            this.done = true;
            UnicastProcessor<T> w = this.window;
            if (w != null) {
                this.window = null;
                w.onError(t);
            }
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            UnicastProcessor<T> w = this.window;
            if (w != null) {
                this.window = null;
                w.onComplete();
            }
            this.actual.onComplete();
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                if (this.firstRequest == 0 && FIRST_REQUEST.compareAndSet(this, 0, 1)) {
                    long u = Operators.multiplyCap(this.size, n);
                    long v = Operators.multiplyCap(this.skip - this.size, n - 1L);
                    long w = Operators.addCap(u, v);
                    this.s.request(w);
                } else {
                    long u = Operators.multiplyCap(this.skip, n);
                    this.s.request(u);
                }
            }
        }

        public void cancel() {
            if (ONCE.compareAndSet(this, 0, 1)) {
                this.dispose();
            }
        }

        @Override
        public boolean isDisposed() {
            return this.once == 1 || this.done;
        }

        @Override
        public void dispose() {
            if (WIP.decrementAndGet(this) == 0) {
                this.s.cancel();
            }
        }

        @Override
        public Subscriber<? super Flux<T>> actual() {
            return this.actual;
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case PARENT: {
                    return this.s;
                }
                case CANCELLED: {
                    return this.once == 1;
                }
                case CAPACITY: {
                    return this.size;
                }
                case TERMINATED: {
                    return this.done;
                }
            }
            return InnerOperator.super.scan(key);
        }

        @Override
        public Stream<? extends Scannable> inners() {
            return Stream.of(this.window);
        }
    }

    static final class WindowExactSubscriber<T>
    implements Disposable,
    InnerOperator<T, Flux<T>> {
        final Subscriber<? super Flux<T>> actual;
        final Supplier<? extends Queue<T>> processorQueueSupplier;
        final int size;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<WindowExactSubscriber> WIP = AtomicIntegerFieldUpdater.newUpdater(WindowExactSubscriber.class, "wip");
        volatile int once;
        static final AtomicIntegerFieldUpdater<WindowExactSubscriber> ONCE = AtomicIntegerFieldUpdater.newUpdater(WindowExactSubscriber.class, "once");
        int index;
        Subscription s;
        UnicastProcessor<T> window;
        boolean done;

        WindowExactSubscriber(Subscriber<? super Flux<T>> actual, int size, Supplier<? extends Queue<T>> processorQueueSupplier) {
            this.actual = actual;
            this.size = size;
            this.processorQueueSupplier = processorQueueSupplier;
            this.wip = 1;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t);
                return;
            }
            int i = this.index;
            UnicastProcessor<T> w = this.window;
            if (i == 0) {
                WIP.getAndIncrement(this);
                w = new UnicastProcessor<T>(this.processorQueueSupplier.get(), this);
                this.window = w;
                this.actual.onNext(w);
            }
            w.onNext(t);
            if (++i == this.size) {
                this.index = 0;
                this.window = null;
                w.onComplete();
            } else {
                this.index = i;
            }
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            this.done = true;
            UnicastProcessor<T> w = this.window;
            if (w != null) {
                this.window = null;
                w.onError(t);
            }
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            UnicastProcessor<T> w = this.window;
            if (w != null) {
                this.window = null;
                w.onComplete();
            }
            this.actual.onComplete();
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                long u = Operators.multiplyCap(this.size, n);
                this.s.request(u);
            }
        }

        public void cancel() {
            if (ONCE.compareAndSet(this, 0, 1)) {
                this.dispose();
            }
        }

        @Override
        public void dispose() {
            if (WIP.decrementAndGet(this) == 0) {
                this.s.cancel();
            }
        }

        @Override
        public Subscriber<? super Flux<T>> actual() {
            return this.actual;
        }

        @Override
        public boolean isDisposed() {
            return this.once == 1 || this.done;
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case PARENT: {
                    return this.s;
                }
                case CANCELLED: {
                    return this.once == 1;
                }
                case CAPACITY: {
                    return this.size;
                }
                case TERMINATED: {
                    return this.done;
                }
            }
            return InnerOperator.super.scan(key);
        }

        @Override
        public Stream<? extends Scannable> inners() {
            return Stream.of(this.window);
        }
    }
}

