/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongConsumer;
import java.util.logging.Level;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import reactor.core.Fuseable;
import reactor.core.publisher.ConnectableFlux;
import reactor.core.publisher.ConnectableFluxOnAssembly;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxCallableOnAssembly;
import reactor.core.publisher.FluxLog;
import reactor.core.publisher.FluxLogFuseable;
import reactor.core.publisher.FluxOnAssembly;
import reactor.core.publisher.FluxPeek;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoCallableOnAssembly;
import reactor.core.publisher.MonoLog;
import reactor.core.publisher.MonoLogFuseable;
import reactor.core.publisher.MonoOnAssembly;
import reactor.core.publisher.ParallelFlux;
import reactor.core.publisher.ParallelFluxOnAssembly;
import reactor.core.publisher.ParallelLog;
import reactor.core.publisher.SignalLogger;
import reactor.core.publisher.SignalPeek;
import reactor.core.publisher.SignalType;
import reactor.util.Logger;
import reactor.util.Loggers;

public abstract class Hooks {
    static volatile OnOperatorHook<?> onOperatorHook;
    static volatile Consumer<? super Throwable> onErrorDroppedHook;
    static volatile Consumer<Object> onNextDroppedHook;
    static volatile BiFunction<? super Throwable, Object, ? extends Throwable> onOperatorErrorHook;
    static final Logger log;

    public static void onErrorDropped(Consumer<? super Throwable> c) {
        if (log.isDebugEnabled()) {
            log.debug("Hooking new default : onErrorDropped");
        }
        onErrorDroppedHook = Objects.requireNonNull(c, "onErrorDroppedHook");
    }

    public static void onNextDropped(Consumer<Object> c) {
        if (log.isDebugEnabled()) {
            log.debug("Hooking new default : onNextDropped");
        }
        onNextDroppedHook = Objects.requireNonNull(c, "onNextDroppedHook");
    }

    public static <T> void onOperator(Function<? super OperatorHook<T>, ? extends OperatorHook<T>> onOperator) {
        if (log.isDebugEnabled()) {
            log.debug("Hooking new default : onOperator");
        }
        onOperatorHook = new OnOperatorHook(Objects.requireNonNull(onOperator, "onOperator"));
    }

    public static void onOperatorError(BiFunction<? super Throwable, Object, ? extends Throwable> f) {
        if (log.isDebugEnabled()) {
            log.debug("Hooking new default : onOperatorError");
        }
        onOperatorErrorHook = Objects.requireNonNull(f, "onOperatorErrorHook");
    }

    public static void resetOnErrorDropped() {
        if (log.isDebugEnabled()) {
            log.debug("Reset to factory defaults : onErrorDropped");
        }
        onErrorDroppedHook = null;
    }

    public static void resetOnNextDropped() {
        if (log.isDebugEnabled()) {
            log.debug("Reset to factory defaults : onNextDropped");
        }
        onNextDroppedHook = null;
    }

    public static void resetOnOperator() {
        if (log.isDebugEnabled()) {
            log.debug("Reset to factory defaults : onOperator");
        }
        onOperatorHook = null;
    }

    public static void resetOnOperatorError() {
        if (log.isDebugEnabled()) {
            log.debug("Reset to factory defaults : onOperatorError");
        }
        onOperatorErrorHook = null;
    }

    Hooks() {
    }

    static {
        boolean globalTrace = Boolean.parseBoolean(System.getProperty("reactor.trace.operatorStacktrace", "false"));
        if (globalTrace) {
            onOperatorHook = new OnOperatorHook(OperatorHook::operatorStacktrace);
        }
        log = Loggers.getLogger(Hooks.class);
    }

    static final class OnOperatorHook<T>
    implements Function<Publisher<T>, Publisher<T>> {
        final Function<? super OperatorHook<T>, ? extends OperatorHook<T>> hook;

        OnOperatorHook(Function<? super OperatorHook<T>, ? extends OperatorHook<T>> hook) {
            this.hook = hook;
        }

        @Override
        public Publisher<T> apply(Publisher<T> publisher) {
            if (this.hook != null && !(publisher instanceof ConnectableFlux)) {
                OperatorHook<T> hooks = Objects.requireNonNull(this.hook.apply(new OperatorHook<T>(publisher)), "hook");
                if (hooks.tracedLevel != null) {
                    hooks = hooks.doOnSignal(new SignalLogger<T>(publisher, hooks.tracedCategory, hooks.tracedLevel, true, hooks.tracedSignals));
                }
                if (hooks != OperatorHook.IGNORE) {
                    publisher = hooks.publisher;
                    boolean trace = hooks.traced;
                    if (trace) {
                        if (publisher instanceof Callable) {
                            if (publisher instanceof Mono) {
                                return new MonoCallableOnAssembly((Mono)publisher);
                            }
                            return new FluxCallableOnAssembly((Flux)publisher);
                        }
                        if (publisher instanceof Mono) {
                            return new MonoOnAssembly((Mono)publisher);
                        }
                        if (publisher instanceof ParallelFlux) {
                            return new ParallelFluxOnAssembly((ParallelFlux)publisher);
                        }
                        return new FluxOnAssembly((Flux)publisher);
                    }
                    return publisher;
                }
            }
            if (this.hook != null && publisher instanceof ConnectableFlux) {
                return new ConnectableFluxOnAssembly((ConnectableFlux)publisher);
            }
            return publisher;
        }
    }

    public static final class OperatorHook<T> {
        static final OperatorHook IGNORE = new OperatorHook(null);
        final Publisher<T> publisher;
        String tracedCategory;
        Level tracedLevel;
        SignalType[] tracedSignals;
        boolean traced;

        public final OperatorHook<T> doOnEach(Consumer<? super T> onNextCall, Consumer<? super Throwable> onErrorCall, Runnable onCompleteCall, Runnable onAfterTerminateCall) {
            return this.doOnSignal(new FluxPeek<T>(Flux.never(), null, onNextCall, onErrorCall, onCompleteCall, onAfterTerminateCall, null, null));
        }

        public final OperatorHook<T> doOnLifecycle(Consumer<? super Subscription> onSubscribeCall, LongConsumer onRequestCall, Runnable onCancelCall) {
            return this.doOnSignal(new FluxPeek(Flux.never(), onSubscribeCall, null, null, null, null, onRequestCall, onCancelCall));
        }

        final OperatorHook<T> doOnSignal(SignalPeek<T> log) {
            if (this == IGNORE || this.publisher instanceof ConnectableFlux) {
                return this;
            }
            if (this.publisher instanceof Mono) {
                if (this.publisher instanceof Fuseable) {
                    return new OperatorHook<T>(new MonoLogFuseable<T>((Mono)this.publisher, log), this.traced, this.tracedCategory, this.tracedLevel, this.tracedSignals);
                }
                return new OperatorHook<T>(new MonoLog<T>((Mono)this.publisher, log), this.traced, this.tracedCategory, this.tracedLevel, this.tracedSignals);
            }
            if (this.publisher instanceof ParallelFlux) {
                return new OperatorHook<T>(new ParallelLog<T>((ParallelFlux)this.publisher, log), this.traced, this.tracedCategory, this.tracedLevel, this.tracedSignals);
            }
            if (this.publisher instanceof Fuseable) {
                return new OperatorHook<T>(new FluxLogFuseable<T>((Flux)this.publisher, log), this.traced, this.tracedCategory, this.tracedLevel, this.tracedSignals);
            }
            return new OperatorHook<T>(new FluxLog<T>((Flux)this.publisher, log), this.traced, this.tracedCategory, this.tracedLevel, this.tracedSignals);
        }

        public final OperatorHook<T> ignore() {
            return IGNORE;
        }

        public final OperatorHook<T> ifFlux() {
            return this.publisher() instanceof Flux ? this : IGNORE;
        }

        public final OperatorHook<T> ifMono() {
            return this.publisher() instanceof Mono ? this : IGNORE;
        }

        public final OperatorHook<T> ifParallelFlux() {
            return this.publisher() instanceof ParallelFlux ? this : IGNORE;
        }

        public final OperatorHook<T> ifName(String ... names) {
            if (this == IGNORE) {
                return this;
            }
            String className = this.publisher().getClass().getSimpleName().replaceAll("Flux|Mono|Parallel|Fuseable", "");
            for (String name : names) {
                if (!className.equalsIgnoreCase(name)) continue;
                return this;
            }
            return IGNORE;
        }

        public final OperatorHook<T> ifNameContains(String ... names) {
            if (this == IGNORE) {
                return this;
            }
            String className = this.publisher().getClass().getSimpleName().replaceAll("Flux|Mono|Parallel|Fuseable", "").toLowerCase();
            for (String name : names) {
                if (!className.contains(name.toLowerCase())) continue;
                return this;
            }
            return IGNORE;
        }

        public OperatorHook<T> log(String category, SignalType ... options) {
            return this.log(category, Level.INFO, options);
        }

        public OperatorHook<T> log(String category, boolean showOperatorLine, SignalType ... options) {
            return this.log(category, Level.INFO, showOperatorLine, options);
        }

        public OperatorHook<T> log(String category, Level level, SignalType ... options) {
            Objects.requireNonNull(level, "level");
            return this.doOnSignal(new SignalLogger<T>(this.publisher, category, level, false, options));
        }

        public OperatorHook<T> log(String category, Level level, boolean showOperatorLine, SignalType ... options) {
            if (this == IGNORE) {
                return this;
            }
            Objects.requireNonNull(level, "level");
            if (showOperatorLine) {
                this.tracedCategory = category;
                this.tracedLevel = level;
                this.tracedSignals = options;
                return this;
            }
            return this.log(category, level, options);
        }

        public OperatorHook<T> operatorStacktrace() {
            if (this == IGNORE) {
                return this;
            }
            this.traced = true;
            return this;
        }

        public Publisher<T> publisher() {
            return this.publisher;
        }

        OperatorHook(Publisher<T> p) {
            this(p, false, null, null, null);
        }

        OperatorHook(Publisher<T> p, boolean traced, String tracedCategory, Level tracedLevel, SignalType[] tracedSignals) {
            this.traced = traced;
            this.publisher = p;
            this.tracedSignals = tracedSignals;
            this.tracedLevel = tracedLevel;
            this.tracedCategory = tracedCategory;
        }
    }
}

