/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.policy;

import java.util.Optional;
import java.util.function.Function;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.policy.Policy;
import org.mule.runtime.core.api.policy.PolicyStateHandler;
import org.mule.runtime.core.api.policy.PolicyStateId;
import org.mule.runtime.core.api.processor.MessageProcessors;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.internal.policy.PolicyEventConverter;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class OperationPolicyProcessor
implements Processor {
    private final Policy policy;
    private final PolicyStateHandler policyStateHandler;
    private final PolicyEventConverter policyEventConverter = new PolicyEventConverter();
    private final Processor nextProcessor;

    public OperationPolicyProcessor(Policy policy, PolicyStateHandler policyStateHandler, Processor nextProcessor) {
        this.policy = policy;
        this.policyStateHandler = policyStateHandler;
        this.nextProcessor = nextProcessor;
    }

    @Override
    public InternalEvent process(InternalEvent operationEvent) throws MuleException {
        return MessageProcessors.processToApply(operationEvent, this);
    }

    @Override
    public Publisher<InternalEvent> apply(Publisher<InternalEvent> publisher) {
        return Mono.from(publisher).then(operationEvent -> {
            PolicyStateId policyStateId = new PolicyStateId(operationEvent.getContext().getCorrelationId(), this.policy.getPolicyId());
            Optional<InternalEvent> latestPolicyState = this.policyStateHandler.getLatestState(policyStateId);
            InternalEvent variablesProviderEvent = latestPolicyState.orElseGet(() -> InternalEvent.builder(operationEvent.getContext()).message(Message.of(null)).build());
            this.policyStateHandler.updateState(policyStateId, variablesProviderEvent);
            InternalEvent policyEvent = this.policyEventConverter.createEvent((InternalEvent)operationEvent, variablesProviderEvent);
            Processor operationCall = this.buildOperationExecutionWithPolicyFunction(this.nextProcessor, (InternalEvent)operationEvent);
            this.policyStateHandler.updateNextOperation(policyStateId.getExecutionIdentifier(), operationCall);
            return this.executePolicyChain((InternalEvent)operationEvent, policyStateId, policyEvent);
        });
    }

    private Mono<InternalEvent> executePolicyChain(InternalEvent operationEvent, PolicyStateId policyStateId, InternalEvent policyEvent) {
        return Mono.just((Object)policyEvent).transform((Function)this.policy.getPolicyChain()).doOnNext(policyChainResult -> this.policyStateHandler.updateState(policyStateId, (InternalEvent)policyChainResult)).map(policyChainResult -> this.policyEventConverter.createEvent((InternalEvent)policyChainResult, operationEvent));
    }

    private Processor buildOperationExecutionWithPolicyFunction(final Processor nextOperation, final InternalEvent operationEvent) {
        return new Processor(){

            @Override
            public InternalEvent process(InternalEvent event) throws MuleException {
                return MessageProcessors.processToApply(event, this);
            }

            @Override
            public Publisher<InternalEvent> apply(Publisher<InternalEvent> publisher) {
                return Mono.from(publisher).then(policyExecuteNextEvent -> {
                    PolicyStateId policyStateId = new PolicyStateId(policyExecuteNextEvent.getContext().getId(), OperationPolicyProcessor.this.policy.getPolicyId());
                    OperationPolicyProcessor.this.policyStateHandler.updateState(policyStateId, (InternalEvent)policyExecuteNextEvent);
                    return Mono.just((Object)policyExecuteNextEvent).map(event -> OperationPolicyProcessor.this.policyEventConverter.createEvent((InternalEvent)event, operationEvent)).transform((Function)nextOperation).map(operationResult -> OperationPolicyProcessor.this.policyEventConverter.createEvent((InternalEvent)operationResult, (InternalEvent)policyExecuteNextEvent));
                });
            }
        };
    }
}

