/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.session;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.MuleSession;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.security.SecurityContext;
import org.mule.runtime.core.api.util.CaseInsensitiveHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public final class DefaultMuleSession
implements MuleSession {
    private static final long serialVersionUID = 3380926585676521866L;
    private static Logger logger = LoggerFactory.getLogger(DefaultMuleSession.class);
    private SecurityContext securityContext;
    private Map<String, TypedValue> properties;

    public DefaultMuleSession() {
        this.properties = Collections.synchronizedMap(new CaseInsensitiveHashMap());
    }

    public DefaultMuleSession(MuleSession session) {
        this.securityContext = session.getSecurityContext();
        this.properties = Collections.synchronizedMap(new CaseInsensitiveHashMap());
        for (String key : session.getPropertyNamesAsSet()) {
            this.properties.put(key, this.createTypedValue(session, key));
        }
    }

    private TypedValue createTypedValue(MuleSession session, String key) {
        return new TypedValue(session.getProperty(key), session.getPropertyDataType(key));
    }

    @Override
    public void setSecurityContext(SecurityContext context) {
        this.securityContext = context;
    }

    @Override
    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    @Override
    public void setProperty(String key, Object value) {
        if (!(value instanceof Serializable)) {
            logger.warn(CoreMessages.sessionPropertyNotSerializableWarning(key).toString());
        }
        this.properties.put(key, new TypedValue(value, DataType.fromObject((Object)value)));
    }

    @Override
    public void setProperty(String key, Object value, DataType dataType) {
        if (!(value instanceof Serializable)) {
            logger.warn(CoreMessages.sessionPropertyNotSerializableWarning(key).toString());
        }
        this.properties.put(key, new TypedValue(value, dataType));
    }

    @Override
    public Set<String> getPropertyNamesAsSet() {
        return Collections.unmodifiableSet(this.properties.keySet());
    }

    @Override
    public void merge(MuleSession updatedSession) {
        if (updatedSession == null) {
            return;
        }
        Iterator<Map.Entry<String, TypedValue>> propertyIterator = this.properties.entrySet().iterator();
        while (propertyIterator.hasNext()) {
            Map.Entry<String, TypedValue> entry = propertyIterator.next();
            if (!(entry.getValue().getValue() instanceof Serializable)) continue;
            propertyIterator.remove();
        }
        for (String updatedPropertyKey : updatedSession.getPropertyNamesAsSet()) {
            this.properties.put(updatedPropertyKey, this.createTypedValue(updatedSession, updatedPropertyKey));
        }
    }

    public Map<String, Object> getProperties() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String key : this.properties.keySet()) {
            TypedValue typedValue = this.properties.get(key);
            result.put(key, typedValue.getValue());
        }
        return result;
    }

    public Map<String, TypedValue> getExtendedProperties() {
        return this.properties;
    }

    public void removeNonSerializableProperties() {
        Iterator<Map.Entry<String, TypedValue>> propertyIterator = this.properties.entrySet().iterator();
        while (propertyIterator.hasNext()) {
            Map.Entry<String, TypedValue> entry = propertyIterator.next();
            if (entry.getValue().getValue() instanceof Serializable) continue;
            logger.warn(CoreMessages.propertyNotSerializableWasDropped(entry.getKey()).toString());
            propertyIterator.remove();
        }
    }

    @Override
    public void setProperty(String key, Serializable value) {
        this.setProperty(key, value, DataType.fromObject((Object)value));
    }

    @Override
    public void setProperty(String key, Serializable value, DataType dataType) {
        this.properties.put(key, new TypedValue((Object)value, dataType));
    }

    @Override
    public Object getProperty(String key) {
        TypedValue typedValue = this.properties.get(key);
        return typedValue == null ? null : typedValue.getValue();
    }

    @Override
    public Object removeProperty(String key) {
        return this.properties.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        DefaultMuleSession copy = new DefaultMuleSession(this);
        copy.removeNonSerializableProperties();
        Map<String, TypedValue> backupProperties = this.properties;
        try {
            this.properties = copy.properties;
            out.defaultWriteObject();
        }
        finally {
            this.properties = backupProperties;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    @Override
    public void clearProperties() {
        this.properties.clear();
    }

    @Override
    public DataType getPropertyDataType(String name) {
        TypedValue typedValue = this.properties.get(name);
        return typedValue == null ? null : typedValue.getDataType();
    }
}

