/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.store;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;

public abstract class ObjectStoreToMapAdapter<T extends Serializable>
implements Map<String, T> {
    protected abstract ObjectStore<T> getObjectStore();

    @Override
    public int size() {
        try {
            return this.getObjectStore().allKeys().size();
        }
        catch (ObjectStoreException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    @Override
    public boolean isEmpty() {
        try {
            return this.getObjectStore().allKeys().isEmpty();
        }
        catch (ObjectStoreException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    @Override
    public boolean containsKey(Object key) {
        try {
            return this.getObjectStore().contains((String)key);
        }
        catch (ObjectStoreException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException("Map adapter for object store does not support contains value");
    }

    @Override
    public T get(Object key) {
        try {
            if (!this.getObjectStore().contains((String)key)) {
                return null;
            }
            return (T)this.getObjectStore().retrieve((String)key);
        }
        catch (ObjectStoreException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    @Override
    public T put(String key, T value) {
        Serializable previousValue = null;
        try {
            if (this.getObjectStore().contains(key)) {
                previousValue = this.getObjectStore().retrieve(key);
                this.getObjectStore().remove(key);
            }
            if (value != null) {
                this.getObjectStore().store(key, value);
            }
            return (T)previousValue;
        }
        catch (ObjectStoreException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    @Override
    public T remove(Object key) {
        try {
            if (this.getObjectStore().contains((String)key)) {
                return (T)this.getObjectStore().remove((String)key);
            }
        }
        catch (ObjectStoreException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends String, ? extends T> mapToAdd) {
        for (String string : mapToAdd.keySet()) {
            this.put(string, (T)((Serializable)mapToAdd.get(string)));
        }
    }

    @Override
    public void clear() {
        try {
            this.getObjectStore().clear();
        }
        catch (ObjectStoreException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    @Override
    public Set<String> keySet() {
        try {
            List allKeys = this.getObjectStore().allKeys();
            return new HashSet<String>(allKeys);
        }
        catch (ObjectStoreException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    @Override
    public Collection<T> values() {
        throw new UnsupportedOperationException("ObjectStoreToMapAdapter does not support values() method");
    }

    @Override
    public Set<Map.Entry<String, T>> entrySet() {
        throw new UnsupportedOperationException("ObjectStoreToMapAdapter does not support entrySet() method");
    }
}

