/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.exception.ErrorMessageAwareException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.meta.AnnotatedObject;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.exception.ErrorTypeLocator;
import org.mule.runtime.core.api.exception.Errors;
import org.mule.runtime.core.api.exception.MessagingException;
import org.mule.runtime.core.api.exception.WrapperErrorMessageAwareException;
import org.mule.runtime.core.api.message.ErrorBuilder;
import org.mule.runtime.core.api.util.ExceptionHandler;
import org.mule.runtime.core.internal.component.ComponentAnnotations;
import org.mule.runtime.core.internal.exception.ErrorMapping;

public class ExceptionUtils {
    public static boolean containsType(Throwable throwable, Class<?> type) {
        return org.apache.commons.lang3.exception.ExceptionUtils.indexOfType((Throwable)throwable, type) > -1;
    }

    public static String getFullStackTraceWithoutMessages(Throwable throwable) {
        StringBuilder builder = new StringBuilder();
        for (String frame : org.apache.commons.lang3.exception.ExceptionUtils.getStackFrames((Throwable)throwable)) {
            builder.append(frame.replaceAll(":\\s+([\\w\\s]*.*)", "").trim()).append(System.lineSeparator());
        }
        return builder.toString();
    }

    public static Optional<ConnectionException> extractConnectionException(Throwable throwable) {
        return ExceptionUtils.extractOfType(throwable, ConnectionException.class);
    }

    public static Optional<Throwable> extractCauseOfType(Throwable throwable, Class<? extends Throwable> throwableType) {
        return ExceptionUtils.extractOfType(throwable, throwableType).map(Throwable::getCause);
    }

    public static <T extends Throwable> Optional<T> extractOfType(Throwable throwable, Class<T> throwableType) {
        if (throwableType.isInstance(throwable)) {
            return Optional.of(throwable);
        }
        if (throwable == null || !ExceptionUtils.containsType(throwable, throwableType)) {
            return Optional.empty();
        }
        return Arrays.stream(org.apache.commons.lang3.exception.ExceptionUtils.getThrowables((Throwable)throwable)).filter(throwableType::isInstance).findFirst();
    }

    public static <T, E extends Exception> T tryExpecting(Class<E> expectedExceptionType, Callable<T> callable, ExceptionHandler<T, E> exceptionHandler) throws E {
        try {
            return callable.call();
        }
        catch (Exception e) {
            if (expectedExceptionType.isInstance(e)) {
                throw e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            return exceptionHandler.handle(e);
        }
    }

    public static Error getErrorFromFailingProcessor(InternalEvent currentEvent, AnnotatedObject processor, Throwable cause, ErrorTypeLocator locator) {
        ErrorType currentError = currentEvent != null ? (ErrorType)currentEvent.getError().map(Error::getErrorType).orElse(null) : null;
        ErrorType foundErrorType = locator.lookupErrorType(cause);
        ErrorType resultError = ExceptionUtils.isUnknownMuleError(foundErrorType) ? currentError : foundErrorType;
        Throwable unwrappedCause = ExceptionUtils.getWrapperErrorCause(cause);
        ErrorType errorType = ExceptionUtils.getComponentIdentifier(processor).map(ci -> locator.lookupComponentErrorType((ComponentIdentifier)ci, unwrappedCause)).orElse(locator.lookupErrorType(cause));
        return ErrorBuilder.builder(cause).errorType(ExceptionUtils.getErrorMappings(processor).stream().filter(m -> m.match(resultError == null || ExceptionUtils.isUnknownMuleError(resultError) ? errorType : currentError)).findFirst().map(ErrorMapping::getTarget).orElse(errorType)).build();
    }

    static boolean isUnknownMuleError(ErrorType type) {
        return type.getNamespace().equals(Errors.CORE_NAMESPACE_NAME) && type.getIdentifier().equals("UNKNOWN");
    }

    public static InternalEvent createErrorEvent(InternalEvent currentEvent, AnnotatedObject obj, MessagingException me, ErrorTypeLocator locator) {
        Object cause = me.getCause() != null ? me.getCause() : me;
        List<ErrorMapping> errorMappings = ExceptionUtils.getErrorMappings(obj);
        if (!errorMappings.isEmpty() || ExceptionUtils.isMessagingExceptionCause(me, (Throwable)cause)) {
            Error newError = ExceptionUtils.getErrorFromFailingProcessor(currentEvent, obj, (Throwable)cause, locator);
            InternalEvent newEvent = InternalEvent.builder(me.getEvent()).error(newError).build();
            me.setProcessedEvent(newEvent);
            return newEvent;
        }
        return currentEvent;
    }

    public static Throwable getErrorMessageAwareExceptionCause(Throwable exception) {
        return exception instanceof ErrorMessageAwareException ? ((ErrorMessageAwareException)exception).getRootCause() : exception;
    }

    public static Throwable getMessagingExceptionCause(Throwable exception) {
        Throwable cause = exception;
        while (cause instanceof MessagingException) {
            cause = cause.getCause();
        }
        return cause != null ? cause : exception;
    }

    public static Throwable getRootCauseException(Throwable exception) {
        return exception instanceof ErrorMessageAwareException ? ((ErrorMessageAwareException)exception).getRootCause() : exception;
    }

    public static Optional<ComponentIdentifier> getComponentIdentifier(AnnotatedObject obj) {
        return Optional.ofNullable((ComponentIdentifier)obj.getAnnotation(ComponentAnnotations.ANNOTATION_NAME));
    }

    private static Throwable getWrapperErrorCause(Throwable exception) {
        return exception instanceof WrapperErrorMessageAwareException ? ((WrapperErrorMessageAwareException)((Object)exception)).getRootCause() : exception;
    }

    private static boolean isMessagingExceptionCause(MessagingException me, Throwable cause) {
        return !me.getEvent().getError().filter(error -> cause.equals(error.getCause())).filter(error -> me.causedExactlyBy(error.getCause().getClass())).isPresent();
    }

    static List<ErrorMapping> getErrorMappings(AnnotatedObject object) {
        List<ErrorMapping> list = (List<ErrorMapping>)object.getAnnotation(ErrorMapping.ANNOTATION_ERROR_MAPPINGS);
        return list != null ? list : Collections.emptyList();
    }
}

