/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.config.custom.CustomizationService;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.internal.config.CustomService;
import org.mule.runtime.core.internal.config.CustomServiceRegistry;

public class DefaultCustomizationService
implements CustomizationService,
CustomServiceRegistry {
    private Map<String, CustomService> muleContextDefaultServices = new HashMap<String, CustomService>();
    private Map<String, CustomService> customServices = new HashMap<String, CustomService>();

    public <T> void overrideDefaultServiceImpl(String serviceId, T serviceImpl) {
        this.muleContextDefaultServices.put(serviceId, new CustomService(serviceImpl));
    }

    public <T> void overrideDefaultServiceClass(String serviceId, Class<T> serviceClass) {
        this.muleContextDefaultServices.put(serviceId, new CustomService(serviceClass));
    }

    @Override
    public Optional<CustomService> getOverriddenService(String serviceId) {
        return Optional.ofNullable(this.muleContextDefaultServices.get(serviceId));
    }

    public <T> void registerCustomServiceImpl(String serviceId, T serviceImpl) {
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)serviceId) ? 1 : 0) != 0, (String)"serviceId cannot be empty");
        Preconditions.checkArgument((serviceImpl != null ? 1 : 0) != 0, (String)"serviceImpl cannot be null");
        this.customServices.put(serviceId, new CustomService(serviceImpl));
    }

    public <T> void registerCustomServiceClass(String serviceId, Class<T> serviceClass) {
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)serviceId) ? 1 : 0) != 0, (String)"serviceId cannot be empty");
        Preconditions.checkArgument((serviceClass != null ? 1 : 0) != 0, (String)"serviceClass cannot be null");
        this.customServices.put(serviceId, new CustomService(serviceClass));
    }

    @Override
    public Map<String, CustomService> getCustomServices() {
        return Collections.unmodifiableMap(this.customServices);
    }
}

