/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.connection;

import org.apache.commons.pool.ObjectPool;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.PoolingListener;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.internal.connection.ConnectionHandlerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PoolingConnectionHandler<C>
implements ConnectionHandlerAdapter<C> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PoolingConnectionHandler.class);
    private C connection;
    private final ObjectPool<C> pool;
    private final PoolingListener poolingListener;

    PoolingConnectionHandler(C connection, ObjectPool<C> pool, PoolingListener poolingListener) {
        this.connection = connection;
        this.pool = pool;
        this.poolingListener = poolingListener;
    }

    public C getConnection() throws ConnectionException {
        Preconditions.checkState((this.connection != null ? 1 : 0) != 0, (String)"Connection has been either released or invalidated");
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        boolean returnAttempted = false;
        try {
            this.poolingListener.onReturn(this.connection);
            this.pool.returnObject(this.connection);
            returnAttempted = true;
        }
        catch (Exception e) {
            LOGGER.warn("Could not return connection to the pool. Connection will be destroyed", (Throwable)e);
        }
        finally {
            try {
                if (!returnAttempted) {
                    this.invalidate();
                }
            }
            finally {
                this.connection = null;
            }
        }
    }

    public void invalidate() {
        try {
            this.pool.invalidateObject(this.connection);
        }
        catch (Exception e) {
            LOGGER.warn("Exception was found trying to invalidate connection of type " + this.connection.getClass().getName(), (Throwable)e);
        }
        finally {
            this.connection = null;
        }
    }

    @Override
    public void close() throws MuleException {
    }
}

