/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transformer.expression;

import java.nio.charset.Charset;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.internal.transformer.expression.AbstractExpressionTransformer;
import org.mule.runtime.core.internal.transformer.expression.ExpressionArgument;

public class ExpressionTransformer
extends AbstractExpressionTransformer {
    private boolean returnSourceIfNull = false;

    @Override
    public Object transformMessage(InternalEvent event, Charset outputEncoding) throws TransformerException {
        Object[] results = new Object[this.arguments.size()];
        int i = 0;
        for (ExpressionArgument argument : this.arguments) {
            try {
                results[i] = argument.evaluate(event);
            }
            catch (ExpressionRuntimeException e) {
                throw new TransformerException(this, (Throwable)((Object)e));
            }
            if (!argument.isOptional() && results[i] == null) {
                throw new TransformerException(CoreMessages.expressionReturnedNull(argument.getExpressionConfig().getExpression()), this);
            }
            ++i;
        }
        if (this.isReturnSourceIfNull() && this.checkIfAllAreNull(results)) {
            return event.getMessage();
        }
        if (results.length == 1) {
            return results[0];
        }
        return results;
    }

    private boolean checkIfAllAreNull(Object[] objects) {
        for (Object object : objects) {
            if (object == null) continue;
            return false;
        }
        return true;
    }

    public boolean isReturnSourceIfNull() {
        return this.returnSourceIfNull;
    }

    public void setReturnSourceIfNull(boolean returnSourceIfNull) {
        this.returnSourceIfNull = returnSourceIfNull;
    }
}

