/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import java.util.HashMap;
import java.util.Map;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.registry.RegistrationException;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.policy.PolicyManager;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.extension.internal.property.PagedOperationModelProperty;
import org.mule.runtime.module.extension.internal.runtime.connectivity.ExtensionConnectionSupplier;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.ExtensionsOAuthManager;
import org.mule.runtime.module.extension.internal.runtime.operation.OAuthOperationMessageProcessor;
import org.mule.runtime.module.extension.internal.runtime.operation.OperationMessageProcessor;
import org.mule.runtime.module.extension.internal.runtime.operation.PagedOperationMessageProcessor;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParametersResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public final class OperationMessageProcessorBuilder {
    private final ExtensionModel extensionModel;
    private final OperationModel operationModel;
    private final PolicyManager policyManager;
    private final MuleContext muleContext;
    private final ExtensionConnectionSupplier extensionConnectionSupplier;
    private final ExtensionsOAuthManager oauthManager;
    private ConfigurationProvider configurationProvider;
    private Map<String, ?> parameters;
    private String target;
    private String targetValue;
    private CursorProviderFactory cursorProviderFactory;
    private RetryPolicyTemplate retryPolicyTemplate;

    public OperationMessageProcessorBuilder(ExtensionModel extensionModel, OperationModel operationModel, PolicyManager policyManager, MuleContext muleContext) {
        Preconditions.checkArgument((extensionModel != null ? 1 : 0) != 0, (String)"ExtensionModel cannot be null");
        Preconditions.checkArgument((operationModel != null ? 1 : 0) != 0, (String)"OperationModel cannot be null");
        Preconditions.checkArgument((policyManager != null ? 1 : 0) != 0, (String)"PolicyManager cannot be null");
        Preconditions.checkArgument((muleContext != null ? 1 : 0) != 0, (String)"muleContext cannot be null");
        this.extensionModel = extensionModel;
        this.operationModel = operationModel;
        this.policyManager = policyManager;
        this.muleContext = muleContext;
        this.extensionConnectionSupplier = this.lookup(ExtensionConnectionSupplier.class);
        this.oauthManager = this.lookup(ExtensionsOAuthManager.class);
    }

    private <T> T lookup(Class<T> type) {
        try {
            return (T)this.muleContext.getRegistry().lookupObject(type);
        }
        catch (RegistrationException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)(type.getName() + " Not Found")), (Throwable)e);
        }
    }

    public OperationMessageProcessorBuilder setConfigurationProvider(ConfigurationProvider configurationProvider) {
        this.configurationProvider = configurationProvider;
        return this;
    }

    public OperationMessageProcessorBuilder setParameters(Map<String, ?> parameters) {
        this.parameters = parameters != null ? parameters : new HashMap();
        return this;
    }

    public OperationMessageProcessorBuilder setTarget(String target) {
        this.target = target;
        return this;
    }

    public OperationMessageProcessorBuilder setTargetValue(String targetValue) {
        this.targetValue = targetValue;
        return this;
    }

    public OperationMessageProcessorBuilder setCursorProviderFactory(CursorProviderFactory cursorProviderFactory) {
        this.cursorProviderFactory = cursorProviderFactory;
        return this;
    }

    public OperationMessageProcessorBuilder setRetryPolicyTemplate(RetryPolicyTemplate retryPolicyTemplate) {
        this.retryPolicyTemplate = retryPolicyTemplate;
        return this;
    }

    public OperationMessageProcessor build() {
        return (OperationMessageProcessor)((Object)ClassUtils.withContextClassLoader((ClassLoader)MuleExtensionUtils.getClassLoader(this.extensionModel), () -> {
            try {
                ExtensionManager extensionManager = this.muleContext.getExtensionManager();
                ResolverSet resolverSet = ParametersResolver.fromValues(this.parameters, this.muleContext).getParametersAsResolverSet((ParameterizedModel)this.operationModel, this.muleContext);
                OperationMessageProcessor processor = this.operationModel.getModelProperty(PagedOperationModelProperty.class).isPresent() ? new PagedOperationMessageProcessor(this.extensionModel, this.operationModel, this.configurationProvider, this.target, this.targetValue, resolverSet, this.cursorProviderFactory, this.retryPolicyTemplate, extensionManager, this.policyManager, this.extensionConnectionSupplier) : (MuleExtensionUtils.supportsOAuth(this.extensionModel) ? new OAuthOperationMessageProcessor(this.extensionModel, this.operationModel, this.configurationProvider, this.target, this.targetValue, resolverSet, this.cursorProviderFactory, this.retryPolicyTemplate, extensionManager, this.policyManager, this.oauthManager) : new OperationMessageProcessor(this.extensionModel, this.operationModel, this.configurationProvider, this.target, this.targetValue, resolverSet, this.cursorProviderFactory, this.retryPolicyTemplate, extensionManager, this.policyManager));
                this.muleContext.getInjector().inject((Object)processor);
                return processor;
            }
            catch (Exception e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }));
    }
}

