/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SubstitutionGroupHandler;
import org.apache.xerces.impl.xs.XMLSchemaException;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSConstraints;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSGrammarBucket;
import org.apache.xerces.impl.xs.XSModelGroupImpl;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.impl.xs.XSWildcardDecl;
import org.apache.xerces.impl.xs.models.CMBuilder;
import org.apache.xerces.impl.xs.util.SimpleLocator;

class XS10Constraints
extends XSConstraints {
    private static final Comparator ELEMENT_PARTICLE_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            XSParticleDecl pDecl1 = (XSParticleDecl)o1;
            XSParticleDecl pDecl2 = (XSParticleDecl)o2;
            XSElementDecl decl1 = (XSElementDecl)pDecl1.fValue;
            XSElementDecl decl2 = (XSElementDecl)pDecl2.fValue;
            String namespace1 = decl1.getNamespace();
            String namespace2 = decl2.getNamespace();
            String name1 = decl1.getName();
            String name2 = decl2.getName();
            boolean sameNamespace = namespace1 == namespace2;
            int namespaceComparison = 0;
            if (!sameNamespace) {
                namespaceComparison = namespace1 != null ? (namespace2 != null ? namespace1.compareTo(namespace2) : 1) : -1;
            }
            return namespaceComparison != 0 ? namespaceComparison : name1.compareTo(name2);
        }
    };

    public XS10Constraints(short schemaVersion) {
        super(SchemaGrammar.getXSAnyType(schemaVersion), schemaVersion);
    }

    @Override
    public boolean overlapUPA(XSElementDecl element, XSWildcardDecl wildcard, SubstitutionGroupHandler sgHandler) {
        if (wildcard.allowNamespace(element.fTargetNamespace)) {
            return true;
        }
        XSElementDecl[] subGroup = sgHandler.getSubstitutionGroup(element, this.fSchemaVersion);
        for (int i = subGroup.length - 1; i >= 0; --i) {
            if (!wildcard.allowNamespace(subGroup[i].fTargetNamespace)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSubsetOf(XSWildcardDecl wildcard, XSWildcardDecl superWildcard) {
        if (superWildcard == null) {
            return false;
        }
        if (superWildcard.fType == 1) {
            return true;
        }
        if (wildcard.fType == 2 && superWildcard.fType == 2 && wildcard.fNamespaceList[0] == superWildcard.fNamespaceList[0]) {
            return true;
        }
        if (wildcard.fType == 3) {
            if (superWildcard.fType == 3 && this.subset2sets(wildcard.fNamespaceList, superWildcard.fNamespaceList)) {
                return true;
            }
            if (superWildcard.fType == 2 && !this.elementInSet(superWildcard.fNamespaceList[0], wildcard.fNamespaceList) && !this.elementInSet(XSWildcardDecl.ABSENT, wildcard.fNamespaceList)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public XSWildcardDecl performUnionWith(XSWildcardDecl wildcard, XSWildcardDecl otherWildcard, short processContents) {
        if (otherWildcard == null) {
            return null;
        }
        XSWildcardDecl unionWildcard = new XSWildcardDecl();
        unionWildcard.fProcessContents = processContents;
        if (this.areSame(wildcard, otherWildcard)) {
            unionWildcard.fType = wildcard.fType;
            unionWildcard.fNamespaceList = wildcard.fNamespaceList;
        } else if (wildcard.fType == 1 || otherWildcard.fType == 1) {
            unionWildcard.fType = 1;
        } else if (wildcard.fType == 3 && otherWildcard.fType == 3) {
            unionWildcard.fType = (short)3;
            unionWildcard.fNamespaceList = this.union2sets(wildcard.fNamespaceList, otherWildcard.fNamespaceList);
        } else if (wildcard.fType == 2 && otherWildcard.fType == 2) {
            unionWildcard.fType = (short)2;
            unionWildcard.fNamespaceList = new String[2];
            unionWildcard.fNamespaceList[0] = XSWildcardDecl.ABSENT;
            unionWildcard.fNamespaceList[1] = XSWildcardDecl.ABSENT;
        } else if (wildcard.fType == 2 && otherWildcard.fType == 3 || wildcard.fType == 3 && otherWildcard.fType == 2) {
            String[] local = null;
            String[] list = null;
            if (wildcard.fType == 2) {
                local = wildcard.fNamespaceList;
                list = otherWildcard.fNamespaceList;
            } else {
                local = otherWildcard.fNamespaceList;
                list = wildcard.fNamespaceList;
            }
            boolean foundAbsent = this.elementInSet(XSWildcardDecl.ABSENT, list);
            if (local[0] != XSWildcardDecl.ABSENT) {
                boolean foundNS = this.elementInSet(local[0], list);
                if (foundNS && foundAbsent) {
                    unionWildcard.fType = 1;
                } else if (foundNS && !foundAbsent) {
                    unionWildcard.fType = (short)2;
                    unionWildcard.fNamespaceList = new String[2];
                    unionWildcard.fNamespaceList[0] = XSWildcardDecl.ABSENT;
                    unionWildcard.fNamespaceList[1] = XSWildcardDecl.ABSENT;
                } else {
                    if (!foundNS && foundAbsent) {
                        return null;
                    }
                    unionWildcard.fType = (short)2;
                    unionWildcard.fNamespaceList = local;
                }
            } else if (foundAbsent) {
                unionWildcard.fType = 1;
            } else {
                unionWildcard.fType = (short)2;
                unionWildcard.fNamespaceList = local;
            }
        }
        return unionWildcard;
    }

    @Override
    public XSWildcardDecl performIntersectionWith(XSWildcardDecl wildcard, XSWildcardDecl otherWildcard, short processContents) {
        if (otherWildcard == null) {
            return null;
        }
        XSWildcardDecl intersectWildcard = new XSWildcardDecl();
        intersectWildcard.fProcessContents = processContents;
        if (this.areSame(wildcard, otherWildcard)) {
            intersectWildcard.fType = wildcard.fType;
            intersectWildcard.fNamespaceList = wildcard.fNamespaceList;
        } else if (wildcard.fType == 1 || otherWildcard.fType == 1) {
            XSWildcardDecl other = wildcard;
            if (wildcard.fType == 1) {
                other = otherWildcard;
            }
            intersectWildcard.fType = other.fType;
            intersectWildcard.fNamespaceList = other.fNamespaceList;
        } else if (wildcard.fType == 2 && otherWildcard.fType == 3 || wildcard.fType == 3 && otherWildcard.fType == 2) {
            String[] list = null;
            String[] other = null;
            if (wildcard.fType == 2) {
                other = wildcard.fNamespaceList;
                list = otherWildcard.fNamespaceList;
            } else {
                other = otherWildcard.fNamespaceList;
                list = wildcard.fNamespaceList;
            }
            int listSize = list.length;
            String[] intersect = new String[listSize];
            int newSize = 0;
            for (int i = 0; i < listSize; ++i) {
                if (list[i] == other[0] || list[i] == XSWildcardDecl.ABSENT) continue;
                intersect[newSize++] = list[i];
            }
            intersectWildcard.fType = (short)3;
            intersectWildcard.fNamespaceList = new String[newSize];
            System.arraycopy(intersect, 0, intersectWildcard.fNamespaceList, 0, newSize);
        } else if (wildcard.fType == 3 && otherWildcard.fType == 3) {
            intersectWildcard.fType = (short)3;
            intersectWildcard.fNamespaceList = this.intersect2sets(wildcard.fNamespaceList, otherWildcard.fNamespaceList);
        } else if (wildcard.fType == 2 && otherWildcard.fType == 2) {
            if (wildcard.fNamespaceList[0] != XSWildcardDecl.ABSENT && otherWildcard.fNamespaceList[0] != XSWildcardDecl.ABSENT) {
                return null;
            }
            XSWildcardDecl local = wildcard;
            if (wildcard.fNamespaceList[0] == XSWildcardDecl.ABSENT) {
                local = otherWildcard;
            }
            intersectWildcard.fType = local.fType;
            intersectWildcard.fNamespaceList = local.fNamespaceList;
        }
        return intersectWildcard;
    }

    @Override
    protected void groupSubsumption(XSParticleDecl dParticle, XSParticleDecl bParticle, XSGrammarBucket grammarBucket, SubstitutionGroupHandler SGHandler, CMBuilder cmBuilder, XMLErrorReporter errorReporter, String dName, SimpleLocator locator) {
        try {
            this.particleValidRestriction(dParticle, SGHandler, bParticle, SGHandler);
        }
        catch (XMLSchemaException e) {
            String key = e.getKey();
            this.reportSchemaError(errorReporter, locator, key, e.getArgs());
            this.reportSchemaError(errorReporter, locator, "src-redefine.6.2.2", new Object[]{dName, key});
        }
    }

    @Override
    protected void typeSubsumption(XSComplexTypeDecl dType, XSComplexTypeDecl bType, XSGrammarBucket grammarBucket, SubstitutionGroupHandler SGHandler, CMBuilder cmBuilder, XMLErrorReporter errorReporter, SimpleLocator locator) {
        try {
            this.particleValidRestriction(dType.fParticle, SGHandler, bType.fParticle, SGHandler);
        }
        catch (XMLSchemaException e) {
            this.reportSchemaError(errorReporter, locator, e.getKey(), e.getArgs());
            this.reportSchemaError(errorReporter, locator, "derivation-ok-restriction.5.4.2", new Object[]{dType.fName});
        }
    }

    private boolean particleValidRestriction(XSParticleDecl dParticle, SubstitutionGroupHandler dSGHandler, XSParticleDecl bParticle, SubstitutionGroupHandler bSGHandler) throws XMLSchemaException {
        return this.particleValidRestriction(dParticle, dSGHandler, bParticle, bSGHandler, true);
    }

    private boolean particleValidRestriction(XSParticleDecl dParticle, SubstitutionGroupHandler dSGHandler, XSParticleDecl bParticle, SubstitutionGroupHandler bSGHandler, boolean checkWCOccurrence) throws XMLSchemaException {
        int bType;
        Vector<XSParticleDecl> dChildren = null;
        Vector bChildren = null;
        int dMinEffectiveTotalRange = -2;
        int dMaxEffectiveTotalRange = -2;
        boolean bExpansionHappened = false;
        if (dParticle.isEmpty() && !bParticle.emptiable()) {
            throw new XMLSchemaException("cos-particle-restrict.a", null);
        }
        if (!dParticle.isEmpty() && bParticle.isEmpty()) {
            throw new XMLSchemaException("cos-particle-restrict.b", null);
        }
        int dType = dParticle.fType;
        if (dType == 3) {
            dType = ((XSModelGroupImpl)dParticle.fValue).fCompositor;
            XSParticleDecl dtmp = this.getNonUnaryGroup(dParticle);
            if (dtmp != dParticle) {
                dParticle = dtmp;
                dType = dParticle.fType;
                if (dType == 3) {
                    dType = ((XSModelGroupImpl)dParticle.fValue).fCompositor;
                }
            }
            dChildren = XS10Constraints.removePointlessChildren(dParticle);
        }
        int dMinOccurs = dParticle.fMinOccurs;
        int dMaxOccurs = dParticle.fMaxOccurs;
        if (dSGHandler != null && dType == 1) {
            XSElementDecl[] subGroup;
            XSElementDecl dElement = (XSElementDecl)dParticle.fValue;
            if (dElement.fScope == 1 && (subGroup = dSGHandler.getSubstitutionGroup(dElement, this.fSchemaVersion)).length > 0) {
                dType = 101;
                dMinEffectiveTotalRange = dMinOccurs;
                dMaxEffectiveTotalRange = dMaxOccurs;
                dChildren = new Vector(subGroup.length + 1);
                for (int i = 0; i < subGroup.length; ++i) {
                    this.addElementToParticleVector(dChildren, subGroup[i]);
                }
                this.addElementToParticleVector(dChildren, dElement);
                Collections.sort(dChildren, ELEMENT_PARTICLE_COMPARATOR);
                dSGHandler = null;
            }
        }
        if ((bType = bParticle.fType) == 3) {
            bType = ((XSModelGroupImpl)bParticle.fValue).fCompositor;
            XSParticleDecl btmp = this.getNonUnaryGroup(bParticle);
            if (btmp != bParticle) {
                bParticle = btmp;
                bType = bParticle.fType;
                if (bType == 3) {
                    bType = ((XSModelGroupImpl)bParticle.fValue).fCompositor;
                }
            }
            bChildren = XS10Constraints.removePointlessChildren(bParticle);
        }
        int bMinOccurs = bParticle.fMinOccurs;
        int bMaxOccurs = bParticle.fMaxOccurs;
        if (bSGHandler != null && bType == 1) {
            XSElementDecl[] bsubGroup;
            XSElementDecl bElement = (XSElementDecl)bParticle.fValue;
            if (bElement.fScope == 1 && (bsubGroup = bSGHandler.getSubstitutionGroup(bElement, this.fSchemaVersion)).length > 0) {
                bType = 101;
                bChildren = new Vector(bsubGroup.length + 1);
                for (int i = 0; i < bsubGroup.length; ++i) {
                    this.addElementToParticleVector(bChildren, bsubGroup[i]);
                }
                this.addElementToParticleVector(bChildren, bElement);
                Collections.sort(bChildren, ELEMENT_PARTICLE_COMPARATOR);
                bSGHandler = null;
                bExpansionHappened = true;
            }
        }
        switch (dType) {
            case 1: {
                switch (bType) {
                    case 1: {
                        this.checkNameAndTypeOK((XSElementDecl)dParticle.fValue, dMinOccurs, dMaxOccurs, (XSElementDecl)bParticle.fValue, bMinOccurs, bMaxOccurs);
                        return bExpansionHappened;
                    }
                    case 2: {
                        this.checkNSCompat((XSElementDecl)dParticle.fValue, dMinOccurs, dMaxOccurs, (XSWildcardDecl)bParticle.fValue, bMinOccurs, bMaxOccurs, checkWCOccurrence);
                        return bExpansionHappened;
                    }
                    case 101: {
                        dChildren = new Vector<XSParticleDecl>();
                        dChildren.addElement(dParticle);
                        this.checkRecurseLax(dChildren, 1, 1, dSGHandler, bChildren, bMinOccurs, bMaxOccurs, bSGHandler);
                        return bExpansionHappened;
                    }
                    case 102: 
                    case 103: {
                        dChildren = new Vector();
                        dChildren.addElement(dParticle);
                        this.checkRecurse(dChildren, 1, 1, dSGHandler, bChildren, bMinOccurs, bMaxOccurs, bSGHandler);
                        return bExpansionHappened;
                    }
                }
                throw new XMLSchemaException("Internal-Error", new Object[]{"in particleValidRestriction"});
            }
            case 2: {
                switch (bType) {
                    case 2: {
                        this.checkNSSubset((XSWildcardDecl)dParticle.fValue, dMinOccurs, dMaxOccurs, (XSWildcardDecl)bParticle.fValue, bMinOccurs, bMaxOccurs);
                        return bExpansionHappened;
                    }
                    case 1: 
                    case 101: 
                    case 102: 
                    case 103: {
                        throw new XMLSchemaException("cos-particle-restrict.2", new Object[]{"any:choice,sequence,all,elt"});
                    }
                }
                throw new XMLSchemaException("Internal-Error", new Object[]{"in particleValidRestriction"});
            }
            case 103: {
                switch (bType) {
                    case 2: {
                        if (dMinEffectiveTotalRange == -2) {
                            dMinEffectiveTotalRange = dParticle.minEffectiveTotalRange();
                        }
                        if (dMaxEffectiveTotalRange == -2) {
                            dMaxEffectiveTotalRange = dParticle.maxEffectiveTotalRange();
                        }
                        this.checkNSRecurseCheckCardinality(dChildren, dMinEffectiveTotalRange, dMaxEffectiveTotalRange, dSGHandler, bParticle, bMinOccurs, bMaxOccurs, checkWCOccurrence);
                        return bExpansionHappened;
                    }
                    case 103: {
                        this.checkRecurse(dChildren, dMinOccurs, dMaxOccurs, dSGHandler, bChildren, bMinOccurs, bMaxOccurs, bSGHandler);
                        return bExpansionHappened;
                    }
                    case 1: 
                    case 101: 
                    case 102: {
                        throw new XMLSchemaException("cos-particle-restrict.2", new Object[]{"all:choice,sequence,elt"});
                    }
                }
                throw new XMLSchemaException("Internal-Error", new Object[]{"in particleValidRestriction"});
            }
            case 101: {
                switch (bType) {
                    case 2: {
                        if (dMinEffectiveTotalRange == -2) {
                            dMinEffectiveTotalRange = dParticle.minEffectiveTotalRange();
                        }
                        if (dMaxEffectiveTotalRange == -2) {
                            dMaxEffectiveTotalRange = dParticle.maxEffectiveTotalRange();
                        }
                        this.checkNSRecurseCheckCardinality(dChildren, dMinEffectiveTotalRange, dMaxEffectiveTotalRange, dSGHandler, bParticle, bMinOccurs, bMaxOccurs, checkWCOccurrence);
                        return bExpansionHappened;
                    }
                    case 101: {
                        this.checkRecurseLax(dChildren, dMinOccurs, dMaxOccurs, dSGHandler, bChildren, bMinOccurs, bMaxOccurs, bSGHandler);
                        return bExpansionHappened;
                    }
                    case 1: 
                    case 102: 
                    case 103: {
                        throw new XMLSchemaException("cos-particle-restrict.2", new Object[]{"choice:all,sequence,elt"});
                    }
                }
                throw new XMLSchemaException("Internal-Error", new Object[]{"in particleValidRestriction"});
            }
            case 102: {
                switch (bType) {
                    case 2: {
                        if (dMinEffectiveTotalRange == -2) {
                            dMinEffectiveTotalRange = dParticle.minEffectiveTotalRange();
                        }
                        if (dMaxEffectiveTotalRange == -2) {
                            dMaxEffectiveTotalRange = dParticle.maxEffectiveTotalRange();
                        }
                        this.checkNSRecurseCheckCardinality(dChildren, dMinEffectiveTotalRange, dMaxEffectiveTotalRange, dSGHandler, bParticle, bMinOccurs, bMaxOccurs, checkWCOccurrence);
                        return bExpansionHappened;
                    }
                    case 103: {
                        this.checkRecurseUnordered(dChildren, dMinOccurs, dMaxOccurs, dSGHandler, bChildren, bMinOccurs, bMaxOccurs, bSGHandler);
                        return bExpansionHappened;
                    }
                    case 102: {
                        this.checkRecurse(dChildren, dMinOccurs, dMaxOccurs, dSGHandler, bChildren, bMinOccurs, bMaxOccurs, bSGHandler);
                        return bExpansionHappened;
                    }
                    case 101: {
                        int min1 = dMinOccurs * dChildren.size();
                        int max1 = dMaxOccurs == -1 ? dMaxOccurs : dMaxOccurs * dChildren.size();
                        this.checkMapAndSum(dChildren, min1, max1, dSGHandler, bChildren, bMinOccurs, bMaxOccurs, bSGHandler);
                        return bExpansionHappened;
                    }
                    case 1: {
                        throw new XMLSchemaException("cos-particle-restrict.2", new Object[]{"seq:elt"});
                    }
                }
                throw new XMLSchemaException("Internal-Error", new Object[]{"in particleValidRestriction"});
            }
        }
        return bExpansionHappened;
    }

    private void addElementToParticleVector(Vector v, XSElementDecl d) {
        XSParticleDecl p = new XSParticleDecl();
        p.fValue = d;
        p.fType = 1;
        v.addElement(p);
    }

    private XSParticleDecl getNonUnaryGroup(XSParticleDecl p) {
        if (p.fType == 1 || p.fType == 2) {
            return p;
        }
        if (p.fMinOccurs == 1 && p.fMaxOccurs == 1 && p.fValue != null && ((XSModelGroupImpl)p.fValue).fParticleCount == 1) {
            return this.getNonUnaryGroup(((XSModelGroupImpl)p.fValue).fParticles[0]);
        }
        return p;
    }

    private static Vector removePointlessChildren(XSParticleDecl p) {
        if (p.fType == 1 || p.fType == 2) {
            return null;
        }
        Vector children = new Vector();
        XSModelGroupImpl group = (XSModelGroupImpl)p.fValue;
        for (int i = 0; i < group.fParticleCount; ++i) {
            XS10Constraints.gatherChildren(group.fCompositor, group.fParticles[i], children);
        }
        return children;
    }

    private static void gatherChildren(int parentType, XSParticleDecl p, Vector children) {
        int min = p.fMinOccurs;
        int max = p.fMaxOccurs;
        short type = p.fType;
        if (type == 3) {
            type = ((XSModelGroupImpl)p.fValue).fCompositor;
        }
        if (type == 1 || type == 2) {
            children.addElement(p);
            return;
        }
        if (min != 1 || max != 1) {
            children.addElement(p);
        } else if (parentType == type) {
            XSModelGroupImpl group = (XSModelGroupImpl)p.fValue;
            for (int i = 0; i < group.fParticleCount; ++i) {
                XS10Constraints.gatherChildren(type, group.fParticles[i], children);
            }
        } else if (!p.isEmpty()) {
            children.addElement(p);
        }
    }

    private void checkNameAndTypeOK(XSElementDecl dElement, int dMin, int dMax, XSElementDecl bElement, int bMin, int bMax) throws XMLSchemaException {
        if (dElement.fName != bElement.fName || dElement.fTargetNamespace != bElement.fTargetNamespace) {
            throw new XMLSchemaException("rcase-NameAndTypeOK.1", new Object[]{dElement.fName, dElement.fTargetNamespace, bElement.fName, bElement.fTargetNamespace});
        }
        if (!bElement.getNillable() && dElement.getNillable()) {
            throw new XMLSchemaException("rcase-NameAndTypeOK.2", new Object[]{dElement.fName});
        }
        if (!this.checkOccurrenceRange(dMin, dMax, bMin, bMax)) {
            throw new XMLSchemaException("rcase-NameAndTypeOK.3", new Object[]{dElement.fName, Integer.toString(dMin), dMax == -1 ? "unbounded" : Integer.toString(dMax), Integer.toString(bMin), bMax == -1 ? "unbounded" : Integer.toString(bMax)});
        }
        if (bElement.getConstraintType() == 2) {
            if (dElement.getConstraintType() != 2) {
                throw new XMLSchemaException("rcase-NameAndTypeOK.4.a", new Object[]{dElement.fName, bElement.fDefault.stringValue()});
            }
            boolean isSimple = false;
            if (dElement.fType.getTypeCategory() == 16 || ((XSComplexTypeDecl)dElement.fType).fContentType == 1) {
                isSimple = true;
            }
            if (!isSimple && !bElement.fDefault.normalizedValue.equals(dElement.fDefault.normalizedValue) || isSimple && !bElement.fDefault.actualValue.equals(dElement.fDefault.actualValue)) {
                throw new XMLSchemaException("rcase-NameAndTypeOK.4.b", new Object[]{dElement.fName, dElement.fDefault.stringValue(), bElement.fDefault.stringValue()});
            }
        }
        this.checkIDConstraintRestriction(dElement, bElement);
        short blockSet1 = dElement.fBlock;
        short blockSet2 = bElement.fBlock;
        if ((blockSet1 & blockSet2) != blockSet2 || blockSet1 == 0 && blockSet2 != 0) {
            throw new XMLSchemaException("rcase-NameAndTypeOK.6", new Object[]{dElement.fName});
        }
        if (!this.checkTypeDerivationOk(dElement.fType, bElement.fType, (short)25)) {
            throw new XMLSchemaException("rcase-NameAndTypeOK.7", new Object[]{dElement.fName, dElement.fType.getName(), bElement.fType.getName()});
        }
    }

    private void checkIDConstraintRestriction(XSElementDecl derivedElemDecl, XSElementDecl baseElemDecl) throws XMLSchemaException {
    }

    private boolean checkOccurrenceRange(int min1, int max1, int min2, int max2) {
        return min1 >= min2 && (max2 == -1 || max1 != -1 && max1 <= max2);
    }

    private void checkNSCompat(XSElementDecl elem, int min1, int max1, XSWildcardDecl wildcard, int min2, int max2, boolean checkWCOccurrence) throws XMLSchemaException {
        if (checkWCOccurrence && !this.checkOccurrenceRange(min1, max1, min2, max2)) {
            throw new XMLSchemaException("rcase-NSCompat.2", new Object[]{elem.fName, Integer.toString(min1), max1 == -1 ? "unbounded" : Integer.toString(max1), Integer.toString(min2), max2 == -1 ? "unbounded" : Integer.toString(max2)});
        }
        if (!wildcard.allowNamespace(elem.fTargetNamespace)) {
            throw new XMLSchemaException("rcase-NSCompat.1", new Object[]{elem.fName, elem.fTargetNamespace});
        }
    }

    private void checkNSSubset(XSWildcardDecl dWildcard, int min1, int max1, XSWildcardDecl bWildcard, int min2, int max2) throws XMLSchemaException {
        if (!this.checkOccurrenceRange(min1, max1, min2, max2)) {
            throw new XMLSchemaException("rcase-NSSubset.2", new Object[]{Integer.toString(min1), max1 == -1 ? "unbounded" : Integer.toString(max1), Integer.toString(min2), max2 == -1 ? "unbounded" : Integer.toString(max2)});
        }
        if (!this.isSubsetOf(dWildcard, bWildcard)) {
            throw new XMLSchemaException("rcase-NSSubset.1", null);
        }
        if (dWildcard.weakerProcessContents(bWildcard)) {
            throw new XMLSchemaException("rcase-NSSubset.3", new Object[]{dWildcard.getProcessContentsAsString(), bWildcard.getProcessContentsAsString()});
        }
    }

    private void checkNSRecurseCheckCardinality(Vector children, int min1, int max1, SubstitutionGroupHandler dSGHandler, XSParticleDecl wildcard, int min2, int max2, boolean checkWCOccurrence) throws XMLSchemaException {
        if (checkWCOccurrence && !this.checkOccurrenceRange(min1, max1, min2, max2)) {
            throw new XMLSchemaException("rcase-NSRecurseCheckCardinality.2", new Object[]{Integer.toString(min1), max1 == -1 ? "unbounded" : Integer.toString(max1), Integer.toString(min2), max2 == -1 ? "unbounded" : Integer.toString(max2)});
        }
        int count = children.size();
        try {
            for (int i = 0; i < count; ++i) {
                XSParticleDecl particle1 = (XSParticleDecl)children.elementAt(i);
                this.particleValidRestriction(particle1, dSGHandler, wildcard, null, false);
            }
        }
        catch (XMLSchemaException e) {
            throw new XMLSchemaException("rcase-NSRecurseCheckCardinality.1", null);
        }
    }

    private void checkRecurse(Vector dChildren, int min1, int max1, SubstitutionGroupHandler dSGHandler, Vector bChildren, int min2, int max2, SubstitutionGroupHandler bSGHandler) throws XMLSchemaException {
        if (!this.checkOccurrenceRange(min1, max1, min2, max2)) {
            throw new XMLSchemaException("rcase-Recurse.1", new Object[]{Integer.toString(min1), max1 == -1 ? "unbounded" : Integer.toString(max1), Integer.toString(min2), max2 == -1 ? "unbounded" : Integer.toString(max2)});
        }
        int count1 = dChildren.size();
        int count2 = bChildren.size();
        int current = 0;
        block2: for (int i = 0; i < count1; ++i) {
            XSParticleDecl particle1 = (XSParticleDecl)dChildren.elementAt(i);
            for (int j = current; j < count2; ++j) {
                XSParticleDecl particle2 = (XSParticleDecl)bChildren.elementAt(j);
                ++current;
                try {
                    this.particleValidRestriction(particle1, dSGHandler, particle2, bSGHandler);
                    continue block2;
                }
                catch (XMLSchemaException e) {
                    if (particle2.emptiable()) continue;
                    throw new XMLSchemaException("rcase-Recurse.2", null);
                }
            }
            throw new XMLSchemaException("rcase-Recurse.2", null);
        }
        for (int j = current; j < count2; ++j) {
            XSParticleDecl particle2 = (XSParticleDecl)bChildren.elementAt(j);
            if (particle2.emptiable()) continue;
            throw new XMLSchemaException("rcase-Recurse.2", null);
        }
    }

    private void checkRecurseUnordered(Vector dChildren, int min1, int max1, SubstitutionGroupHandler dSGHandler, Vector bChildren, int min2, int max2, SubstitutionGroupHandler bSGHandler) throws XMLSchemaException {
        if (!this.checkOccurrenceRange(min1, max1, min2, max2)) {
            throw new XMLSchemaException("rcase-RecurseUnordered.1", new Object[]{Integer.toString(min1), max1 == -1 ? "unbounded" : Integer.toString(max1), Integer.toString(min2), max2 == -1 ? "unbounded" : Integer.toString(max2)});
        }
        int count1 = dChildren.size();
        int count2 = bChildren.size();
        boolean[] foundIt = new boolean[count2];
        block2: for (int i = 0; i < count1; ++i) {
            XSParticleDecl particle1 = (XSParticleDecl)dChildren.elementAt(i);
            for (int j = 0; j < count2; ++j) {
                XSParticleDecl particle2 = (XSParticleDecl)bChildren.elementAt(j);
                try {
                    this.particleValidRestriction(particle1, dSGHandler, particle2, bSGHandler);
                    if (foundIt[j]) {
                        throw new XMLSchemaException("rcase-RecurseUnordered.2", null);
                    }
                    foundIt[j] = true;
                    continue block2;
                }
                catch (XMLSchemaException e) {
                    continue;
                }
            }
            throw new XMLSchemaException("rcase-RecurseUnordered.2", null);
        }
        for (int j = 0; j < count2; ++j) {
            XSParticleDecl particle2 = (XSParticleDecl)bChildren.elementAt(j);
            if (foundIt[j] || particle2.emptiable()) continue;
            throw new XMLSchemaException("rcase-RecurseUnordered.2", null);
        }
    }

    private void checkRecurseLax(Vector dChildren, int min1, int max1, SubstitutionGroupHandler dSGHandler, Vector bChildren, int min2, int max2, SubstitutionGroupHandler bSGHandler) throws XMLSchemaException {
        if (!this.checkOccurrenceRange(min1, max1, min2, max2)) {
            throw new XMLSchemaException("rcase-RecurseLax.1", new Object[]{Integer.toString(min1), max1 == -1 ? "unbounded" : Integer.toString(max1), Integer.toString(min2), max2 == -1 ? "unbounded" : Integer.toString(max2)});
        }
        int count1 = dChildren.size();
        int count2 = bChildren.size();
        int current = 0;
        block2: for (int i = 0; i < count1; ++i) {
            XSParticleDecl particle1 = (XSParticleDecl)dChildren.elementAt(i);
            for (int j = current; j < count2; ++j) {
                XSParticleDecl particle2 = (XSParticleDecl)bChildren.elementAt(j);
                ++current;
                try {
                    if (!this.particleValidRestriction(particle1, dSGHandler, particle2, bSGHandler)) continue block2;
                    --current;
                    continue block2;
                }
                catch (XMLSchemaException e) {
                    continue;
                }
            }
            throw new XMLSchemaException("rcase-RecurseLax.2", null);
        }
    }

    private void checkMapAndSum(Vector dChildren, int min1, int max1, SubstitutionGroupHandler dSGHandler, Vector bChildren, int min2, int max2, SubstitutionGroupHandler bSGHandler) throws XMLSchemaException {
        if (!this.checkOccurrenceRange(min1, max1, min2, max2)) {
            throw new XMLSchemaException("rcase-MapAndSum.2", new Object[]{Integer.toString(min1), max1 == -1 ? "unbounded" : Integer.toString(max1), Integer.toString(min2), max2 == -1 ? "unbounded" : Integer.toString(max2)});
        }
        int count1 = dChildren.size();
        int count2 = bChildren.size();
        block2: for (int i = 0; i < count1; ++i) {
            XSParticleDecl particle1 = (XSParticleDecl)dChildren.elementAt(i);
            for (int j = 0; j < count2; ++j) {
                XSParticleDecl particle2 = (XSParticleDecl)bChildren.elementAt(j);
                try {
                    this.particleValidRestriction(particle1, dSGHandler, particle2, bSGHandler);
                    continue block2;
                }
                catch (XMLSchemaException e) {
                    continue;
                }
            }
            throw new XMLSchemaException("rcase-MapAndSum.1", null);
        }
    }

    @Override
    protected final boolean checkEmptyFacets(XSSimpleType baseType) {
        return true;
    }
}

