/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.capability.xml.schema.builder;

import java.math.BigInteger;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.config.spring.internal.dsl.SchemaConstants;
import org.mule.runtime.core.api.NestedProcessor;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.annotation.Extensible;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.internal.property.QNameModelProperty;
import org.mule.runtime.module.extension.internal.capability.xml.schema.builder.SchemaBuilder;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.Attribute;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.ComplexContent;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.ExplicitGroup;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.ExtensionType;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.GroupRef;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.LocalComplexType;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.NamedGroup;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.ObjectFactory;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.TopLevelComplexType;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.TopLevelElement;
import org.mule.runtime.module.extension.internal.loader.java.property.TypeRestrictionModelProperty;

abstract class ExecutableTypeSchemaDelegate {
    protected final SchemaBuilder builder;
    protected final ObjectFactory objectFactory = new ObjectFactory();
    private final Map<String, NamedGroup> substitutionGroups = new LinkedHashMap<String, NamedGroup>();
    private final DslSyntaxResolver dsl;

    ExecutableTypeSchemaDelegate(SchemaBuilder builder) {
        this.builder = builder;
        this.dsl = builder.getDslResolver();
    }

    protected ExtensionType createExecutableType(String name, QName base, DslElementSyntax dslSyntax) {
        TopLevelComplexType complexType = new TopLevelComplexType();
        complexType.setName(name);
        ComplexContent complexContent = new ComplexContent();
        complexType.setComplexContent(complexContent);
        ExtensionType complexContentExtension = new ExtensionType();
        complexContentExtension.setBase(base);
        complexContent.setExtension(complexContentExtension);
        if (dslSyntax.requiresConfig()) {
            Attribute configAttr = this.builder.createAttribute("config-ref", "Specify which configuration to use for this invocation.", true, SchemaConstants.SUBSTITUTABLE_NAME);
            complexContentExtension.getAttributeOrAttributeGroup().add(configAttr);
        }
        this.builder.getSchema().getSimpleTypeOrComplexTypeOrGroup().add(complexType);
        return complexContentExtension;
    }

    protected void registerParameterGroup(ExtensionType type, ParameterGroupModel group) {
        if (group.isShowInDsl()) {
            this.builder.addInlineParameterGroup(group, type.getSequence());
        } else {
            this.registerParameters(type, group.getParameterModels());
        }
    }

    protected ExtensionType registerParameters(ExtensionType type, List<ParameterModel> parameterModels) {
        LinkedList<TopLevelElement> childElements = new LinkedList<TopLevelElement>();
        parameterModels.forEach(parameter -> {
            DslElementSyntax paramDsl = this.dsl.resolve(parameter);
            MetadataType parameterType = parameter.getType();
            if (this.isOperation(parameterType)) {
                String maxOccurs = parameterType instanceof ArrayType ? "unbounded" : "1";
                childElements.add(this.generateNestedProcessorElement(paramDsl, (ParameterModel)parameter, maxOccurs));
            } else {
                boolean shouldDeclare = true;
                if (parameter.getModelProperty(QNameModelProperty.class).isPresent() && !parameter.getDslConfiguration().allowsReferences()) {
                    shouldDeclare = false;
                }
                if (shouldDeclare) {
                    this.builder.declareAsParameter(parameterType, type, (ParameterModel)parameter, paramDsl, (List<TopLevelElement>)childElements);
                }
            }
        });
        if (!childElements.isEmpty()) {
            if (type.getSequence() == null) {
                ExplicitGroup all = new ExplicitGroup();
                all.setMinOccurs(BigInteger.ZERO);
                all.setMaxOccurs("1");
                this.builder.addParameterToSequence(childElements, all);
                type.setSequence(all);
            } else {
                this.builder.addParameterToSequence(childElements, type.getSequence());
            }
        }
        return type;
    }

    protected void initialiseSequence(ExtensionType operationType) {
        if (operationType.getSequence() == null) {
            ExplicitGroup sequence = new ExplicitGroup();
            sequence.setMinOccurs(BigInteger.ZERO);
            sequence.setMaxOccurs("1");
            operationType.setSequence(sequence);
        }
    }

    private TopLevelElement generateNestedProcessorElement(DslElementSyntax paramDsl, ParameterModel parameterModel, String maxOccurs) {
        LocalComplexType collectionComplexType = new LocalComplexType();
        GroupRef group = this.generateNestedProcessorGroup(parameterModel, maxOccurs);
        collectionComplexType.setGroup(group);
        collectionComplexType.setAnnotation(this.builder.createDocAnnotation(parameterModel.getDescription()));
        TopLevelElement collectionElement = new TopLevelElement();
        collectionElement.setName(paramDsl.getElementName());
        collectionElement.setMinOccurs(parameterModel.isRequired() ? BigInteger.ONE : BigInteger.ZERO);
        collectionElement.setMaxOccurs(maxOccurs);
        collectionElement.setComplexType(collectionComplexType);
        collectionElement.setAnnotation(this.builder.createDocAnnotation(""));
        return collectionElement;
    }

    private GroupRef generateNestedProcessorGroup(ParameterModel parameterModel, String maxOccurs) {
        QName ref = SchemaConstants.MULE_MESSAGE_PROCESSOR_TYPE;
        TypeRestrictionModelProperty restrictionCapability = parameterModel.getModelProperty(TypeRestrictionModelProperty.class).orElse(null);
        if (restrictionCapability != null) {
            ref = this.getSubstitutionGroup(restrictionCapability.getType());
            ref = new QName(ref.getNamespaceURI(), this.getGroupName(ref.getLocalPart()), ref.getPrefix());
        }
        GroupRef group = new GroupRef();
        group.setRef(ref);
        group.setMinOccurs(parameterModel.isRequired() ? BigInteger.ONE : BigInteger.ZERO);
        group.setMaxOccurs(maxOccurs);
        return group;
    }

    private boolean isOperation(MetadataType type) {
        if (!type.getMetadataFormat().equals((Object)MetadataFormat.JAVA)) {
            return false;
        }
        final Reference isOperation = new Reference((Object)false);
        type.accept(new MetadataTypeVisitor(){

            public void visitObject(ObjectType objectType) {
                ExtensionMetadataTypeUtils.getType((MetadataType)objectType).filter(NestedProcessor.class::isAssignableFrom).ifPresent(clazz -> {
                    Boolean cfr_ignored_0 = (Boolean)isOperation.set((Object)true);
                });
            }

            public void visitArrayType(ArrayType arrayType) {
                arrayType.getType().accept((MetadataTypeVisitor)this);
            }
        });
        return (Boolean)isOperation.get();
    }

    protected QName getSubstitutionGroup(Class<?> type) {
        return new QName(this.builder.getSchema().getTargetNamespace(), this.registerExtensibleElement(type));
    }

    private String registerExtensibleElement(Class<?> type) {
        NamedGroup group;
        Extensible extensible = type.getAnnotation(Extensible.class);
        Preconditions.checkArgument((extensible != null ? 1 : 0) != 0, (String)String.format("Type %s is not extensible", type.getName()));
        String name = extensible.alias();
        if (StringUtils.isBlank((String)name)) {
            name = type.getName() + "-OperationGroup";
        }
        if ((group = this.substitutionGroups.get(name)) == null) {
            TopLevelElement element = new TopLevelElement();
            element.setName(name);
            element.setAbstract(true);
            element.setSubstitutionGroup(SchemaConstants.MULE_ABSTRACT_OPERATOR);
            this.builder.getSchema().getSimpleTypeOrComplexTypeOrGroup().add(element);
            group = new NamedGroup();
            group.setName(this.getGroupName(name));
            this.builder.getSchema().getSimpleTypeOrComplexTypeOrGroup().add(group);
            this.substitutionGroups.put(name, group);
            element = new TopLevelElement();
            element.setRef(new QName(this.builder.getSchema().getTargetNamespace(), name));
            group.getChoice().getParticle().add(this.objectFactory.createElement(element));
        }
        return name;
    }

    private String getGroupName(String name) {
        return name + "-group";
    }
}

