/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.function;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import org.eclipse.wst.xml.xpath2.api.EvaluationContext;
import org.eclipse.wst.xml.xpath2.api.Item;
import org.eclipse.wst.xml.xpath2.api.ResultBuffer;
import org.eclipse.wst.xml.xpath2.api.StaticContext;
import org.eclipse.wst.xml.xpath2.api.typesystem.TypeDefinition;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.SeqType;
import org.eclipse.wst.xml.xpath2.processor.internal.function.FnData;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyAtomicType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NumericType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSAnyURI;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDouble;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSString;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSUntypedAtomic;
import org.eclipse.wst.xml.xpath2.processor.internal.types.builtin.BuiltinTypeLibrary;

public abstract class Function
implements org.eclipse.wst.xml.xpath2.api.Function {
    protected static DatatypeFactory _datatypeFactory;
    protected QName _name;
    protected int _min_arity;
    protected int _max_arity;

    public Function(QName name, int arity) {
        this._name = name;
        if (arity < 0) {
            throw new RuntimeException("We want to avoid this!");
        }
        this._min_arity = arity;
        this._max_arity = arity;
    }

    public Function(QName name, int min_arity, int max_arity) {
        this._name = name;
        if (min_arity < 0 || max_arity < 0 || max_arity < min_arity) {
            throw new RuntimeException("We want to avoid this!");
        }
        this._min_arity = min_arity;
        this._max_arity = max_arity;
    }

    public QName name() {
        return this._name;
    }

    public int min_arity() {
        return this._min_arity;
    }

    public int max_arity() {
        return this._max_arity;
    }

    public boolean matches_arity(int actual_arity) {
        if (actual_arity < this.min_arity()) {
            return false;
        }
        return actual_arity <= this.max_arity();
    }

    public String signature() {
        return Function.signature(this);
    }

    public static String signature(Function f) {
        return Function.signature(f.name(), f.is_vararg() ? -1 : f.min_arity());
    }

    public static String signature(QName name, int arity) {
        String n = name.expanded_name();
        if (n == null) {
            return null;
        }
        n = n + "_";
        n = arity < 0 ? n + "x" : n + arity;
        return n;
    }

    public ResultSequence evaluate(Collection<org.eclipse.wst.xml.xpath2.api.ResultSequence> args) throws DynamicError {
        throw new UnsupportedOperationException();
    }

    public static org.eclipse.wst.xml.xpath2.api.ResultSequence convert_argument(org.eclipse.wst.xml.xpath2.api.ResultSequence arg, SeqType expected) throws DynamicError {
        ResultBuffer result = new ResultBuffer();
        AnyType expected_type = expected.type();
        if (expected_type instanceof AnyAtomicType) {
            AnyAtomicType expected_aat = (AnyAtomicType)expected_type;
            org.eclipse.wst.xml.xpath2.api.ResultSequence rs = FnData.atomize(arg);
            Iterator<Item> i = rs.iterator();
            while (i.hasNext()) {
                AnyType item = (AnyType)i.next();
                if (item instanceof XSUntypedAtomic) {
                    ResultSequence converted = null;
                    if (expected_aat instanceof XSString) {
                        XSString strType = new XSString(item.getStringValue());
                        converted = ResultSequenceFactory.create_new(strType);
                    } else {
                        converted = ResultSequenceFactory.create_new(item);
                    }
                    result.concat(converted);
                    continue;
                }
                if (item instanceof XSAnyURI && expected_aat instanceof XSString) {
                    result.add(new XSString(item.getStringValue()));
                    continue;
                }
                if (item instanceof NumericType) {
                    if (expected_aat instanceof XSDouble) {
                        XSDouble doubleType = new XSDouble(item.getStringValue());
                        result.add(doubleType);
                        continue;
                    }
                    result.add(item);
                    continue;
                }
                result.add(item);
            }
            return expected.match(result.getSequence());
        }
        return expected.match(arg);
    }

    public static Collection<org.eclipse.wst.xml.xpath2.api.ResultSequence> convert_arguments(Collection<? extends org.eclipse.wst.xml.xpath2.api.ResultSequence> args, Collection<? extends SeqType> expected) throws DynamicError {
        ArrayList<org.eclipse.wst.xml.xpath2.api.ResultSequence> result = new ArrayList<org.eclipse.wst.xml.xpath2.api.ResultSequence>();
        assert (args.size() <= expected.size());
        Iterator<? extends org.eclipse.wst.xml.xpath2.api.ResultSequence> argi = args.iterator();
        Iterator<? extends SeqType> expi = expected.iterator();
        while (argi.hasNext()) {
            result.add(Function.convert_argument(argi.next(), expi.next()));
        }
        return result;
    }

    protected static ResultSequence getResultSetForArityZero(EvaluationContext ec) throws DynamicError {
        ResultSequence rs = ResultSequenceFactory.create_new();
        Item contextItem = ec.getContextItem();
        if (contextItem == null) {
            throw DynamicError.contextUndefined();
        }
        rs.add(new XSString(contextItem.getStringValue()));
        return rs;
    }

    public boolean is_vararg() {
        return this._min_arity != this._max_arity;
    }

    @Override
    public String getName() {
        return this.name().local();
    }

    @Override
    public int getMinArity() {
        return this.min_arity();
    }

    @Override
    public int getMaxArity() {
        return this.max_arity();
    }

    @Override
    public boolean isVariableArgument() {
        return this.is_vararg();
    }

    @Override
    public boolean canMatchArity(int actualArity) {
        return this.matches_arity(actualArity);
    }

    @Override
    public TypeDefinition getResultType() {
        return BuiltinTypeLibrary.XS_UNTYPED;
    }

    @Override
    public TypeDefinition getArgumentType(int index) {
        return BuiltinTypeLibrary.XS_UNTYPED;
    }

    @Override
    public String getArgumentNameHint(int index) {
        return "argument_" + index;
    }

    @Override
    public TypeDefinition computeReturnType(Collection<TypeDefinition> args, StaticContext sc) {
        return BuiltinTypeLibrary.XS_UNTYPED;
    }

    @Override
    public org.eclipse.wst.xml.xpath2.api.ResultSequence evaluate(Collection<org.eclipse.wst.xml.xpath2.api.ResultSequence> args, EvaluationContext evaluationContext) {
        ResultSequence result = this.evaluate(args);
        return result;
    }

    static {
        try {
            _datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException("Cannot initialize XML datatypes", e);
        }
    }
}

