/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Exceptions;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.InnerConsumer;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.InnerProducer;
import reactor.core.publisher.Operators;

final class FluxPublishMulticast<T, R>
extends FluxSource<T, R>
implements Fuseable {
    final Function<? super Flux<T>, ? extends Publisher<? extends R>> transform;
    final Supplier<? extends Queue<T>> queueSupplier;
    final int prefetch;

    FluxPublishMulticast(Publisher<? extends T> source, Function<? super Flux<T>, ? extends Publisher<? extends R>> transform, int prefetch, Supplier<? extends Queue<T>> queueSupplier) {
        super(source);
        if (prefetch < 1) {
            throw new IllegalArgumentException("prefetch > 0 required but it was " + prefetch);
        }
        this.prefetch = prefetch;
        this.transform = Objects.requireNonNull(transform, "transform");
        this.queueSupplier = Objects.requireNonNull(queueSupplier, "queueSupplier");
    }

    @Override
    public long getPrefetch() {
        return this.prefetch;
    }

    @Override
    public void subscribe(Subscriber<? super R> s) {
        Publisher<? extends R> out;
        FluxPublishMulticaster multicast = new FluxPublishMulticaster(this.prefetch, this.queueSupplier);
        try {
            out = Objects.requireNonNull(this.transform.apply(multicast), "The transform returned a null Publisher");
        }
        catch (Throwable ex) {
            Operators.error(s, Operators.onOperatorError(ex));
            return;
        }
        if (out instanceof Fuseable) {
            out.subscribe(new CancelFuseableMulticaster<R>(s, multicast));
        } else {
            out.subscribe(new CancelMulticaster<R>(s, multicast));
        }
        this.source.subscribe(multicast);
    }

    static final class CancelFuseableMulticaster<T>
    implements InnerOperator<T, T>,
    Fuseable.QueueSubscription<T> {
        final Subscriber<? super T> actual;
        final FluxPublishMulticaster<?, ?> parent;
        Fuseable.QueueSubscription<T> s;

        CancelFuseableMulticaster(Subscriber<? super T> actual, FluxPublishMulticaster<?, ?> parent) {
            this.actual = actual;
            this.parent = parent;
        }

        @Override
        public Subscriber<? super T> actual() {
            return this.actual;
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case PARENT: {
                    return this.s;
                }
            }
            return InnerOperator.super.scan(key);
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            this.s.cancel();
            this.parent.cancel();
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = Operators.as(s);
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            this.actual.onNext(t);
        }

        public void onError(Throwable t) {
            if (!this.parent.terminate()) {
                Operators.onErrorDropped(t);
                return;
            }
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.parent.terminate()) {
                this.actual.onComplete();
            }
        }

        @Override
        public int requestFusion(int requestedMode) {
            return this.s.requestFusion(requestedMode);
        }

        @Override
        public T poll() {
            return (T)this.s.poll();
        }

        @Override
        public boolean isEmpty() {
            return this.s.isEmpty();
        }

        @Override
        public int size() {
            return this.s.size();
        }

        @Override
        public void clear() {
            this.s.clear();
        }
    }

    static final class CancelMulticaster<T>
    implements InnerOperator<T, T>,
    Fuseable.QueueSubscription<T> {
        final Subscriber<? super T> actual;
        final FluxPublishMulticaster<?, ?> parent;
        Subscription s;

        CancelMulticaster(Subscriber<? super T> actual, FluxPublishMulticaster<?, ?> parent) {
            this.actual = actual;
            this.parent = parent;
        }

        @Override
        public Subscriber<? super T> actual() {
            return this.actual;
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case PARENT: {
                    return this.s;
                }
            }
            return InnerOperator.super.scan(key);
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            this.s.cancel();
            this.parent.cancel();
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            this.actual.onNext(t);
        }

        public void onError(Throwable t) {
            if (!this.parent.terminate()) {
                Operators.onErrorDropped(t);
                return;
            }
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.parent.terminate()) {
                this.actual.onComplete();
            }
        }

        @Override
        public int requestFusion(int requestedMode) {
            return 0;
        }

        @Override
        public void clear() {
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public T poll() {
            return null;
        }
    }

    static final class PublishMulticastInner<T>
    implements InnerProducer<T> {
        final FluxPublishMulticaster<T, ?> parent;
        final Subscriber<? super T> actual;
        volatile long requested;
        static final AtomicLongFieldUpdater<PublishMulticastInner> REQUESTED = AtomicLongFieldUpdater.newUpdater(PublishMulticastInner.class, "requested");
        volatile int once;
        static final AtomicIntegerFieldUpdater<PublishMulticastInner> ONCE = AtomicIntegerFieldUpdater.newUpdater(PublishMulticastInner.class, "once");

        PublishMulticastInner(FluxPublishMulticaster<T, ?> parent, Subscriber<? super T> actual) {
            this.parent = parent;
            this.actual = actual;
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case REQUESTED_FROM_DOWNSTREAM: {
                    return this.requested;
                }
                case PARENT: {
                    return this.parent;
                }
                case CANCELLED: {
                    return this.once == 1;
                }
            }
            return InnerProducer.super.scan(key);
        }

        @Override
        public Subscriber<? super T> actual() {
            return this.actual;
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                Operators.getAndAddCap(REQUESTED, this, n);
                this.parent.drain();
            }
        }

        public void cancel() {
            if (ONCE.compareAndSet(this, 0, 1)) {
                this.parent.removeAndDrain(this);
            }
        }

        void produced(long n) {
            if (this.requested != Long.MAX_VALUE) {
                REQUESTED.addAndGet(this, -n);
            }
        }
    }

    static final class FluxPublishMulticaster<T, R>
    extends Flux<T>
    implements InnerConsumer<T> {
        final int limit;
        final int prefetch;
        final Supplier<? extends Queue<T>> queueSupplier;
        Queue<T> queue;
        volatile Subscription s;
        static final AtomicReferenceFieldUpdater<FluxPublishMulticaster, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(FluxPublishMulticaster.class, Subscription.class, "s");
        volatile int wip;
        static final AtomicIntegerFieldUpdater<FluxPublishMulticaster> WIP = AtomicIntegerFieldUpdater.newUpdater(FluxPublishMulticaster.class, "wip");
        volatile PublishMulticastInner<T>[] subscribers;
        static final AtomicReferenceFieldUpdater<FluxPublishMulticaster, PublishMulticastInner[]> SUBSCRIBERS = AtomicReferenceFieldUpdater.newUpdater(FluxPublishMulticaster.class, PublishMulticastInner[].class, "subscribers");
        static final PublishMulticastInner[] EMPTY = new PublishMulticastInner[0];
        static final PublishMulticastInner[] TERMINATED = new PublishMulticastInner[0];
        volatile boolean done;
        volatile boolean connected;
        volatile boolean cancelled;
        Throwable error;
        int produced;
        int sourceMode;

        FluxPublishMulticaster(int prefetch, Supplier<? extends Queue<T>> queueSupplier) {
            this.prefetch = prefetch;
            this.limit = prefetch - (prefetch >> 2);
            this.queueSupplier = queueSupplier;
            this.subscribers = EMPTY;
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case PARENT: {
                    return this.s;
                }
                case ERROR: {
                    return this.error;
                }
                case CANCELLED: {
                    return this.cancelled;
                }
                case TERMINATED: {
                    return this.done;
                }
                case PREFETCH: {
                    return this.prefetch;
                }
                case BUFFERED: {
                    return this.queue != null ? this.queue.size() : 0;
                }
            }
            return null;
        }

        @Override
        public Stream<? extends Scannable> inners() {
            return Stream.of(this.subscribers);
        }

        public void subscribe(Subscriber<? super T> s) {
            PublishMulticastInner<? super T> pcs = new PublishMulticastInner<T>(this, s);
            s.onSubscribe(pcs);
            if (this.add(pcs)) {
                if (pcs.once != 0) {
                    this.removeAndDrain(pcs);
                } else {
                    this.drain();
                }
            } else {
                Throwable ex = this.error;
                if (ex != null) {
                    s.onError(ex);
                } else {
                    s.onComplete();
                }
            }
        }

        public void onSubscribe(Subscription s) {
            if (Operators.setOnce(S, this, s)) {
                if (s instanceof Fuseable.QueueSubscription) {
                    Fuseable.QueueSubscription qs = (Fuseable.QueueSubscription)s;
                    int m = qs.requestFusion(3);
                    if (m == 1) {
                        this.sourceMode = m;
                        this.queue = qs;
                        this.done = true;
                        this.connected = true;
                        this.drain();
                        return;
                    }
                    if (m == 2) {
                        this.sourceMode = m;
                        this.queue = qs;
                        this.connected = true;
                        s.request((long)this.prefetch);
                        return;
                    }
                }
                this.queue = this.queueSupplier.get();
                this.connected = true;
                s.request((long)this.prefetch);
            }
        }

        public void onNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t);
                return;
            }
            if (this.sourceMode != 2 && !this.queue.offer(t)) {
                this.onError(Operators.onOperatorError(this.s, Exceptions.failWithOverflow("Queue full?!"), t));
                return;
            }
            this.drain();
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            this.error = t;
            this.done = true;
            this.drain();
        }

        public void onComplete() {
            this.done = true;
            this.drain();
        }

        void drain() {
            if (WIP.getAndIncrement(this) != 0) {
                return;
            }
            if (this.sourceMode == 1) {
                this.drainSync();
            } else {
                this.drainAsync();
            }
        }

        void drainSync() {
            int missed = 1;
            do {
                long e;
                if (!this.connected) continue;
                if (this.cancelled) {
                    this.queue.clear();
                    return;
                }
                Queue<T> queue = this.queue;
                PublishMulticastInner<T>[] a = this.subscribers;
                int n = a.length;
                if (n == 0) continue;
                long r = Long.MAX_VALUE;
                for (int i = 0; i < n; ++i) {
                    r = Math.min(r, a[i].requested);
                }
                for (e = 0L; e != r; ++e) {
                    int i;
                    T v;
                    if (this.cancelled) {
                        queue.clear();
                        return;
                    }
                    try {
                        v = queue.poll();
                    }
                    catch (Throwable ex) {
                        this.error = Operators.onOperatorError(this.s, ex);
                        queue.clear();
                        a = SUBSCRIBERS.getAndSet(this, TERMINATED);
                        n = a.length;
                        for (int i2 = 0; i2 < n; ++i2) {
                            a[i2].actual.onError(ex);
                        }
                        return;
                    }
                    if (v == null) {
                        a = SUBSCRIBERS.getAndSet(this, TERMINATED);
                        n = a.length;
                        for (i = 0; i < n; ++i) {
                            a[i].actual.onComplete();
                        }
                        return;
                    }
                    for (i = 0; i < n; ++i) {
                        a[i].actual.onNext(v);
                    }
                }
                if (this.cancelled) {
                    queue.clear();
                    return;
                }
                if (queue.isEmpty()) {
                    a = SUBSCRIBERS.getAndSet(this, TERMINATED);
                    n = a.length;
                    for (int i = 0; i < n; ++i) {
                        a[i].actual.onComplete();
                    }
                    return;
                }
                if (e == 0L) continue;
                for (int i = 0; i < n; ++i) {
                    a[i].produced(e);
                }
            } while ((missed = WIP.addAndGet(this, -missed)) != 0);
        }

        void drainAsync() {
            int missed = 1;
            int p = this.produced;
            do {
                if (this.connected) {
                    if (this.cancelled) {
                        this.queue.clear();
                        return;
                    }
                    Queue<T> queue = this.queue;
                    PublishMulticastInner<T>[] a = this.subscribers;
                    int n = a.length;
                    if (n != 0) {
                        boolean d;
                        long e;
                        long r = Long.MAX_VALUE;
                        for (int i = 0; i < n; ++i) {
                            r = Math.min(r, a[i].requested);
                        }
                        for (e = 0L; e != r; ++e) {
                            boolean empty;
                            T v;
                            if (this.cancelled) {
                                queue.clear();
                                return;
                            }
                            d = this.done;
                            try {
                                v = queue.poll();
                            }
                            catch (Throwable ex) {
                                queue.clear();
                                this.error = Operators.onOperatorError(this.s, ex);
                                a = SUBSCRIBERS.getAndSet(this, TERMINATED);
                                n = a.length;
                                for (int i = 0; i < n; ++i) {
                                    a[i].actual.onError(ex);
                                }
                                return;
                            }
                            boolean bl = empty = v == null;
                            if (d) {
                                Throwable ex = this.error;
                                if (ex != null) {
                                    queue.clear();
                                    a = SUBSCRIBERS.getAndSet(this, TERMINATED);
                                    n = a.length;
                                    for (int i = 0; i < n; ++i) {
                                        a[i].actual.onError(ex);
                                    }
                                    return;
                                }
                                if (empty) {
                                    a = SUBSCRIBERS.getAndSet(this, TERMINATED);
                                    n = a.length;
                                    for (int i = 0; i < n; ++i) {
                                        a[i].actual.onComplete();
                                    }
                                    return;
                                }
                            }
                            if (empty) break;
                            for (int i = 0; i < n; ++i) {
                                a[i].actual.onNext(v);
                            }
                            if (++p != this.limit) continue;
                            this.s.request((long)p);
                            p = 0;
                        }
                        if (e == r) {
                            if (this.cancelled) {
                                queue.clear();
                                return;
                            }
                            d = this.done;
                            if (d) {
                                int i;
                                Throwable ex = this.error;
                                if (ex != null) {
                                    queue.clear();
                                    a = SUBSCRIBERS.getAndSet(this, TERMINATED);
                                    n = a.length;
                                    for (i = 0; i < n; ++i) {
                                        a[i].actual.onError(ex);
                                    }
                                    return;
                                }
                                if (queue.isEmpty()) {
                                    a = SUBSCRIBERS.getAndSet(this, TERMINATED);
                                    n = a.length;
                                    for (i = 0; i < n; ++i) {
                                        a[i].actual.onComplete();
                                    }
                                    return;
                                }
                            }
                        }
                        if (e != 0L) {
                            for (int i = 0; i < n; ++i) {
                                a[i].produced(e);
                            }
                        }
                    }
                }
                this.produced = p;
            } while ((missed = WIP.addAndGet(this, -missed)) != 0);
        }

        boolean add(PublishMulticastInner<T> s) {
            PublishMulticastInner[] b;
            PublishMulticastInner<T>[] a;
            do {
                if ((a = this.subscribers) == TERMINATED) {
                    return false;
                }
                int n = a.length;
                b = new PublishMulticastInner[n + 1];
                System.arraycopy(a, 0, b, 0, n);
                b[n] = s;
            } while (!SUBSCRIBERS.compareAndSet(this, a, b));
            return true;
        }

        void removeAndDrain(PublishMulticastInner<T> s) {
            PublishMulticastInner[] b;
            PublishMulticastInner<T>[] a;
            do {
                if ((a = this.subscribers) == TERMINATED || a == EMPTY) {
                    return;
                }
                int n = a.length;
                int j = -1;
                for (int i = 0; i < n; ++i) {
                    if (a[i] != s) continue;
                    j = i;
                    break;
                }
                if (j < 0) {
                    return;
                }
                if (n == 1) {
                    b = EMPTY;
                    continue;
                }
                b = new PublishMulticastInner[n - 1];
                System.arraycopy(a, 0, b, 0, j);
                System.arraycopy(a, j + 1, b, j, n - j - 1);
            } while (!SUBSCRIBERS.compareAndSet(this, a, b));
            this.drain();
        }

        void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.terminate();
            }
        }

        boolean terminate() {
            if (Operators.replace(S, this, Operators.cancelledSubscription())) {
                this.subscribers = TERMINATED;
                if (WIP.getAndIncrement(this) == 0 && this.connected) {
                    this.queue.clear();
                }
                return true;
            }
            return false;
        }
    }
}

