/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.soap.internal.runtime.connection;

import java.util.Arrays;
import javax.inject.Inject;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.soap.MessageDispatcherProvider;
import org.mule.runtime.extension.api.soap.SoapServiceProvider;
import org.mule.runtime.extension.api.soap.SoapServiceProviderConfigurationException;
import org.mule.runtime.extension.api.soap.message.MessageDispatcher;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.module.extension.soap.internal.runtime.connection.ForwardingSoapClient;
import org.mule.runtime.soap.api.SoapService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForwardingSoapClientConnectionProvider
implements ConnectionProvider<ForwardingSoapClient>,
Lifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(ForwardingSoapClientConnectionProvider.class);
    private MuleContext muleContext;
    @Inject
    private SoapService soapService;
    @Inject
    private HttpService httpService;
    private final SoapServiceProvider serviceProvider;
    private final MessageDispatcherProvider<MessageDispatcher> transportProvider;

    ForwardingSoapClientConnectionProvider(SoapServiceProvider serviceProvider, MessageDispatcherProvider<? extends MessageDispatcher> transportProvider, MuleContext muleContext) {
        this.serviceProvider = serviceProvider;
        this.transportProvider = transportProvider;
        this.muleContext = muleContext;
    }

    public ForwardingSoapClient connect() throws ConnectionException {
        return new ForwardingSoapClient(this.soapService, this.serviceProvider, this.transportProvider);
    }

    public void disconnect(ForwardingSoapClient connection) {
        connection.disconnect();
    }

    public ConnectionValidationResult validate(ForwardingSoapClient connection) {
        return ConnectionValidationResult.success();
    }

    public void initialise() throws InitialisationException {
        try {
            this.serviceProvider.validateConfiguration();
        }
        catch (SoapServiceProviderConfigurationException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        LifecycleUtils.initialiseIfNeeded(Arrays.asList(this.transportProvider, this.serviceProvider), (boolean)true, (MuleContext)this.muleContext);
    }

    public void dispose() {
        LifecycleUtils.disposeIfNeeded(Arrays.asList(this.transportProvider, this.serviceProvider), (Logger)LOGGER);
    }

    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded(Arrays.asList(this.transportProvider, this.serviceProvider));
    }

    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded(Arrays.asList(this.transportProvider, this.serviceProvider));
    }
}

