/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.json;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.ma.json.JsonHandlerMap;
import net.sf.saxon.ma.json.JsonParser;
import net.sf.saxon.ma.json.JsonToXMLFn;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;

public class ParseJsonFn
extends JsonToXMLFn {
    protected Item eval(String input, MapItem options, XPathContext context) throws XPathException {
        return ParseJsonFn.parse(input, options, context);
    }

    public static Item parse(String input, MapItem options, XPathContext context) throws XPathException {
        JsonParser parser = new JsonParser(context.getConfiguration().getValidCharacterChecker());
        options = JsonParser.checkOptions(options, context);
        int flags = JsonParser.getFlags(options, context, false);
        JsonHandlerMap handler = new JsonHandlerMap(context, flags);
        if ((flags & 0x20) != 0) {
            throw new XPathException("parse-json: duplicates=retain is not allowed", "FOJS0005");
        }
        if ((flags & 0x1E0) == 0) {
            flags |= 0x80;
        }
        handler.setFallbackFunction(options, context);
        parser.parse(input, flags, handler, context);
        return handler.getResult().head();
    }
}

