/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.function;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.wst.xml.xpath2.api.Function;
import org.eclipse.wst.xml.xpath2.api.FunctionLibrary;

public class FunctionLibraryImpl
implements FunctionLibrary {
    private String _namespace;
    private Map<String, Function> _functions;

    public FunctionLibraryImpl(String ns) {
        this._namespace = ns;
        this._functions = new HashMap<String, Function>();
    }

    public void addFunction(Function x) {
        this._functions.put(FunctionLibraryImpl.signature(x), x);
    }

    private static String signature(Function f) {
        return FunctionLibraryImpl.signature(f.getName(), f.isVariableArgument() ? -1 : f.getMinArity());
    }

    private static String signature(String name, int arity) {
        return name + "_" + (arity < 0 ? "x" : Integer.valueOf(arity));
    }

    @Override
    public boolean functionExists(String name, int arity) {
        return this.resolveFunction(name, arity) != null;
    }

    @Override
    public Function resolveFunction(String localName, int arity) {
        Function f = this._functions.get(FunctionLibraryImpl.signature(localName, arity));
        if (f != null || arity == -1) {
            return f;
        }
        f = this._functions.get(FunctionLibraryImpl.signature(localName, -1));
        if (f == null) {
            return null;
        }
        if (f.canMatchArity(arity)) {
            return f;
        }
        return null;
    }

    @Override
    public String getNamespace() {
        return this._namespace;
    }
}

