/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.context.notification;

import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.spi.LoggerContext;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.AnnotatedObject;
import org.mule.runtime.core.api.InternalEventContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.DefaultMuleConfiguration;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.context.notification.EnrichedNotificationInfo;
import org.mule.runtime.core.api.context.notification.FlowStackElement;
import org.mule.runtime.core.api.context.notification.FlowTraceManager;
import org.mule.runtime.core.api.context.notification.MessageProcessorNotification;
import org.mule.runtime.core.api.context.notification.PipelineMessageNotification;
import org.mule.runtime.core.api.execution.LocationExecutionContextProvider;
import org.mule.runtime.core.internal.context.notification.DefaultFlowCallStack;
import org.mule.runtime.core.internal.context.notification.DefaultProcessorsTrace;
import org.mule.runtime.core.internal.context.notification.FlowNotificationTextDebugger;
import org.mule.runtime.core.internal.context.notification.MessageProcessorTextDebugger;
import org.mule.runtime.core.internal.logging.LogConfigChangeSubject;

public class MessageProcessingFlowTraceManager
extends LocationExecutionContextProvider
implements FlowTraceManager,
MuleContextAware,
Initialisable,
Disposable {
    public static final String FLOW_STACK_INFO_KEY = "FlowStack";
    private final FlowNotificationTextDebugger pipelineProcessorDebugger;
    private final MessageProcessorTextDebugger messageProcessorTextDebugger;
    private MuleContext muleContext;
    private PropertyChangeListener logConfigChangeListener = evt -> this.handleNotificationListeners();

    public MessageProcessingFlowTraceManager() {
        this.messageProcessorTextDebugger = new MessageProcessorTextDebugger(this);
        this.pipelineProcessorDebugger = new FlowNotificationTextDebugger(this);
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public void initialise() throws InitialisationException {
        LoggerContext context = LogManager.getContext((boolean)false);
        if (context != null && context instanceof LogConfigChangeSubject) {
            ((LogConfigChangeSubject)context).registerLogConfigChangeListener(this.logConfigChangeListener);
        }
        this.handleNotificationListeners();
    }

    public void dispose() {
        LoggerContext context = LogManager.getContext((boolean)false);
        if (context != null && context instanceof LogConfigChangeSubject) {
            ((LogConfigChangeSubject)context).unregisterLogConfigChangeListener(this.logConfigChangeListener);
        }
        this.removeNotificationListeners();
    }

    protected void handleNotificationListeners() {
        if (!this.muleContext.getNotificationManager().isDisposed()) {
            if (DefaultMuleConfiguration.isFlowTrace()) {
                this.muleContext.getNotificationManager().addListener(this.messageProcessorTextDebugger);
                this.muleContext.getNotificationManager().addListener(this.pipelineProcessorDebugger);
            } else {
                this.removeNotificationListeners();
            }
        }
    }

    protected void removeNotificationListeners() {
        if (!this.muleContext.getNotificationManager().isDisposed()) {
            this.muleContext.getNotificationManager().removeListener(this.messageProcessorTextDebugger);
            this.muleContext.getNotificationManager().removeListener(this.pipelineProcessorDebugger);
        }
    }

    public void onMessageProcessorNotificationPreInvoke(MessageProcessorNotification notification) {
        String resolveProcessorRepresentation = MessageProcessingFlowTraceManager.resolveProcessorRepresentation((String)this.muleContext.getConfiguration().getId(), (String)(notification.getComponent().getLocation() != null ? notification.getComponent().getLocation().getLocation() : null), (Object)notification.getProcessor());
        InternalEventContext eventContext = notification.getEventContext();
        if (eventContext != null) {
            ((DefaultProcessorsTrace)eventContext.getProcessorsTrace()).addExecutedProcessors(resolveProcessorRepresentation);
        }
        if (notification.getFlowCallStack() != null) {
            ((DefaultFlowCallStack)notification.getFlowCallStack()).setCurrentProcessorPath(resolveProcessorRepresentation);
        }
    }

    public void onPipelineNotificationComplete(PipelineMessageNotification notification) {
        this.onFlowComplete(notification.getInfo());
    }

    public void onPipelineNotificationStart(PipelineMessageNotification notification) {
        this.onFlowStart(notification.getInfo(), notification.getResourceIdentifier());
    }

    @Override
    public void onFlowStart(EnrichedNotificationInfo notificationInfo, String flowName) {
        if (notificationInfo.getFlowCallStack() instanceof DefaultFlowCallStack) {
            ((DefaultFlowCallStack)notificationInfo.getFlowCallStack()).push(new FlowStackElement(flowName, null));
        }
    }

    @Override
    public void onFlowComplete(EnrichedNotificationInfo notificationInfo) {
        if (notificationInfo.getFlowCallStack() instanceof DefaultFlowCallStack) {
            ((DefaultFlowCallStack)notificationInfo.getFlowCallStack()).pop();
        }
    }

    @Override
    public Map<String, Object> getContextInfo(EnrichedNotificationInfo notificationInfo, AnnotatedObject lastProcessed) {
        if (DefaultMuleConfiguration.isFlowTrace()) {
            return Collections.singletonMap(FLOW_STACK_INFO_KEY, notificationInfo.getFlowCallStack().toString());
        }
        return Collections.emptyMap();
    }
}

