/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.context.notification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.mule.runtime.core.api.context.notification.ListenerSubscriptionPair;
import org.mule.runtime.core.api.context.notification.Notification;
import org.mule.runtime.core.api.context.notification.NotificationListener;
import org.mule.runtime.core.api.context.notification.NotifierCallback;
import org.mule.runtime.core.internal.context.notification.Sender;

public class Policy {
    private Map<Class<? extends Notification>, Collection<Sender>> eventToSenders = new HashMap<Class<? extends Notification>, Collection<Sender>>();
    private ConcurrentMap knownEventsExact = new ConcurrentHashMap();
    private ConcurrentMap knownEventsSuper = new ConcurrentHashMap();

    Policy(Map<Class<? extends NotificationListener>, Set<Class<? extends Notification>>> interfaceToEvents, Set<ListenerSubscriptionPair> listenerSubscriptionPairs, Set<Class<? extends NotificationListener>> disabledInterfaces, Set<Class<? extends Notification>> disabledEvents) {
        for (ListenerSubscriptionPair pair : listenerSubscriptionPairs) {
            NotificationListener listener = pair.getListener();
            for (Class<? extends NotificationListener> iface : interfaceToEvents.keySet()) {
                if (!Policy.notASubclassOfAnyClassInSet(disabledInterfaces, iface) || !iface.isAssignableFrom(listener.getClass())) continue;
                Set<Class<? extends Notification>> events = interfaceToEvents.get(iface);
                for (Class<? extends Notification> event : events) {
                    if (!Policy.notASubclassOfAnyClassInSet(disabledEvents, event)) continue;
                    this.knownEventsExact.put(event, Boolean.TRUE);
                    this.knownEventsSuper.put(event, Boolean.TRUE);
                    if (!this.eventToSenders.containsKey(event)) {
                        this.eventToSenders.put(event, new ArrayList());
                    }
                    this.eventToSenders.get(event).add(new Sender(pair));
                }
            }
        }
    }

    protected static boolean notASubclassOfAnyClassInSet(Set set, Class clazz) {
        for (Class disabled : set) {
            if (!disabled.isAssignableFrom(clazz)) continue;
            return false;
        }
        return true;
    }

    protected static boolean notASuperclassOfAnyClassInSet(Set set, Class clazz) {
        for (Class disabled : set) {
            if (!clazz.isAssignableFrom(disabled)) continue;
            return false;
        }
        return true;
    }

    public void dispatch(Notification notification, NotifierCallback notifier) {
        if (null != notification) {
            boolean found;
            Class<?> notfnClass = notification.getClass();
            if (!this.knownEventsExact.containsKey(notfnClass)) {
                boolean found2 = this.doDispatch(notification, notfnClass, notifier);
                this.knownEventsExact.put(notfnClass, found2);
            } else if (((Boolean)this.knownEventsExact.get(notfnClass)).booleanValue() && !(found = this.doDispatch(notification, notfnClass, notifier))) {
                this.knownEventsExact.put(notfnClass, found);
            }
        }
    }

    protected boolean doDispatch(Notification notification, Class<? extends Notification> notfnClass, NotifierCallback notifier) {
        boolean found = false;
        for (Class<? extends Notification> event : this.eventToSenders.keySet()) {
            if (!event.isAssignableFrom(notfnClass)) continue;
            found = true;
            for (Sender sender : this.eventToSenders.get(event)) {
                sender.dispatch(notification, notifier);
            }
        }
        return found;
    }

    public boolean isNotificationEnabled(Class notfnClass) {
        Class event;
        Iterator<Object> events;
        boolean found;
        if (!this.knownEventsSuper.containsKey(notfnClass)) {
            found = false;
            events = this.knownEventsSuper.keySet().iterator();
            while (events.hasNext() && !found) {
                event = (Class)events.next();
                found = (Boolean)this.knownEventsSuper.get(event) != false && notfnClass.isAssignableFrom(event);
            }
            this.knownEventsSuper.put(notfnClass, found);
        }
        if (!this.knownEventsExact.containsKey(notfnClass)) {
            found = false;
            events = this.eventToSenders.keySet().iterator();
            while (events.hasNext() && !found) {
                event = (Class)events.next();
                found = event.isAssignableFrom(notfnClass);
            }
            this.knownEventsExact.put(notfnClass, found);
        }
        return (Boolean)this.knownEventsSuper.get(notfnClass) != false || (Boolean)this.knownEventsExact.get(notfnClass) != false;
    }
}

