/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.enricher;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.AbstractAnnotatedObject;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.AbstractMessageProcessorOwner;
import org.mule.runtime.core.api.processor.MessageProcessors;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.Scope;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.api.session.DefaultMuleSession;
import org.mule.runtime.core.api.util.StringUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public class MessageEnricher
extends AbstractMessageProcessorOwner
implements Scope {
    private List<EnrichExpressionPair> enrichExpressionPairs = new ArrayList<EnrichExpressionPair>();
    private Processor enrichmentProcessor;

    @Override
    public InternalEvent process(InternalEvent event) throws MuleException {
        return MessageProcessors.processToApply(event, this);
    }

    protected InternalEvent enrich(InternalEvent currentEvent, InternalEvent enrichmentEvent, String sourceExpressionArg, String targetExpressionArg, ExtendedExpressionManager expressionManager) {
        TypedValue typedValue;
        if (StringUtils.isEmpty(sourceExpressionArg)) {
            sourceExpressionArg = "#[mel:payload:]";
        }
        if ((typedValue = expressionManager.evaluate(sourceExpressionArg, enrichmentEvent, this.getLocation())).getValue() instanceof Message) {
            Message muleMessage = (Message)typedValue.getValue();
            typedValue = new TypedValue(muleMessage.getPayload().getValue(), muleMessage.getPayload().getDataType());
        }
        if (!StringUtils.isEmpty(targetExpressionArg)) {
            InternalEvent.Builder eventBuilder = InternalEvent.builder(currentEvent);
            expressionManager.enrich(targetExpressionArg, currentEvent, eventBuilder, this.getLocation(), typedValue);
            return eventBuilder.build();
        }
        return InternalEvent.builder(currentEvent).message(Message.builder((Message)currentEvent.getMessage()).value(typedValue.getValue()).mediaType(typedValue.getDataType().getMediaType()).build()).build();
    }

    @Override
    public Publisher<InternalEvent> apply(Publisher<InternalEvent> publisher) {
        return Flux.from(publisher).flatMap(event -> Flux.from(MessageProcessors.processWithChildContext(InternalEvent.builder(event).session(new DefaultMuleSession(event.getSession())).build(), (ReactiveProcessor)this.enrichmentProcessor, Optional.ofNullable(this.getLocation()))).map(Exceptions.checkedFunction(response -> this.enrich((InternalEvent)response, (InternalEvent)event))).defaultIfEmpty(event));
    }

    protected InternalEvent enrich(InternalEvent event, InternalEvent eventToEnrich) throws MuleException {
        ExtendedExpressionManager expressionManager = this.muleContext.getExpressionManager();
        if (event != null) {
            for (EnrichExpressionPair pair : this.enrichExpressionPairs) {
                eventToEnrich = this.enrich(eventToEnrich, event, pair.getSource(), pair.getTarget(), expressionManager);
            }
        }
        InternalEvent.setCurrentEvent(eventToEnrich);
        return eventToEnrich;
    }

    @Override
    public void initialise() throws InitialisationException {
        this.enrichmentProcessor = MessageProcessors.newChain(MessageProcessors.getProcessingStrategy(this.muleContext, this.getRootContainerName()), this.enrichmentProcessor);
        LifecycleUtils.initialiseIfNeeded(this.enrichmentProcessor, this.muleContext);
    }

    public void setEnrichmentMessageProcessor(Processor enrichmentProcessor) {
        this.enrichmentProcessor = enrichmentProcessor;
    }

    public void setMessageProcessor(Processor enrichmentProcessor) {
        this.setEnrichmentMessageProcessor(enrichmentProcessor);
    }

    public void setEnrichExpressionPairs(List<EnrichExpressionPair> enrichExpressionPairs) {
        this.enrichExpressionPairs = enrichExpressionPairs;
    }

    public void addEnrichExpressionPair(EnrichExpressionPair pair) {
        this.enrichExpressionPairs.add(pair);
    }

    @Override
    protected List<Processor> getOwnedMessageProcessors() {
        return Collections.singletonList(this.enrichmentProcessor);
    }

    public static class EnrichExpressionPair
    extends AbstractAnnotatedObject {
        private String source;
        private String target;

        public EnrichExpressionPair() {
        }

        public EnrichExpressionPair(String target) {
            this.target = target;
        }

        public EnrichExpressionPair(String source, String target) {
            this.source = source;
            this.target = target;
        }

        public String getSource() {
            return this.source;
        }

        public void setSource(String source) {
            this.source = source;
        }

        public String getTarget() {
            return this.target;
        }

        public void setTarget(String target) {
            this.target = target;
        }
    }
}

