/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.keygenerator;

import java.security.MessageDigest;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.MuleEventKeyGenerator;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SHA256MuleEventKeyGenerator
implements MuleEventKeyGenerator,
MuleContextAware {
    private static final Logger logger = LoggerFactory.getLogger(SHA256MuleEventKeyGenerator.class);
    private MuleContext muleContext;

    @Override
    public String generateKey(InternalEvent event) {
        try {
            byte[] bytesOfMessage = event.getMessageAsBytes(this.muleContext);
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            String key = StringUtils.toHexString(md.digest(bytesOfMessage));
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Generated key for event: %s key: %s", event, key));
            }
            return key;
        }
        catch (Exception e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }
}

