/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.message;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.exception.Errors;

public final class ErrorTypeBuilder {
    private String identifier;
    private String namespace;
    private ErrorType parentErrorType;

    public static ErrorTypeBuilder builder() {
        return new ErrorTypeBuilder();
    }

    private ErrorTypeBuilder() {
    }

    public ErrorTypeBuilder identifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    public ErrorTypeBuilder namespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public ErrorTypeBuilder parentErrorType(ErrorType parentErrorType) {
        this.parentErrorType = parentErrorType;
        return this;
    }

    public ErrorType build() {
        Preconditions.checkState((this.identifier != null ? 1 : 0) != 0, (String)"string representation cannot be null");
        Preconditions.checkState((this.namespace != null ? 1 : 0) != 0, (String)"namespace representation cannot be null");
        if (!this.isOrphan()) {
            Preconditions.checkState((this.parentErrorType != null ? 1 : 0) != 0, (String)"parent error type cannot be null");
        }
        return new ErrorTypeImplementation(this.identifier, this.namespace, this.parentErrorType);
    }

    private boolean isOrphan() {
        return (this.identifier.equals("ANY") || this.identifier.equals("CRITICAL")) && this.namespace.equals(Errors.CORE_NAMESPACE_NAME);
    }

    private static final class ErrorTypeImplementation
    implements ErrorType {
        private String identifier;
        private String namespace;
        private ErrorType parentErrorType;

        private ErrorTypeImplementation(String identifier, String namespace, ErrorType parentErrorType) {
            this.identifier = identifier;
            this.namespace = namespace;
            this.parentErrorType = parentErrorType;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public ErrorType getParentErrorType() {
            return this.parentErrorType;
        }

        public String toString() {
            return String.format("%s:%s", this.namespace, this.identifier);
        }

        public boolean equals(Object obj) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
        }
    }
}

