/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.retry.reactor;

import java.time.Duration;
import org.mule.runtime.core.internal.retry.reactor.BackoffDelay;
import org.mule.runtime.core.internal.retry.reactor.RepeatContext;
import org.mule.runtime.core.internal.retry.reactor.RetryContext;

public class DefaultContext<T>
implements RetryContext<T>,
RepeatContext<T> {
    final T applicationContext;
    final long iteration;
    final Long repeatCompanionValue;
    final Throwable exception;
    final BackoffDelay backoff;
    BackoffDelay lastBackoff;

    public DefaultContext(T applicationContext, long iteration, BackoffDelay backoff, long repeatCompanionValue) {
        this(applicationContext, iteration, backoff, repeatCompanionValue, null);
    }

    public DefaultContext(T applicationContext, long iteration, BackoffDelay backoff, Throwable exception) {
        this(applicationContext, iteration, backoff, null, exception);
    }

    private DefaultContext(T applicationContext, long iteration, BackoffDelay backoff, Long repeatCompanionValue, Throwable exception) {
        this.applicationContext = applicationContext;
        this.iteration = iteration;
        this.backoff = backoff;
        this.repeatCompanionValue = repeatCompanionValue;
        this.exception = exception;
    }

    @Override
    public T applicationContext() {
        return this.applicationContext;
    }

    @Override
    public long iteration() {
        return this.iteration;
    }

    @Override
    public Long companionValue() {
        return this.repeatCompanionValue;
    }

    @Override
    public Throwable exception() {
        return this.exception;
    }

    @Override
    public Duration backoff() {
        return this.backoff == null ? null : this.backoff.delay;
    }

    public String toString() {
        if (this.exception != null) {
            return String.format("iteration=%d exception=%s backoff=%s", this.iteration, this.exception, this.backoff);
        }
        return String.format("iteration=%d repeatCompanionValue=%s backoff=%s", this.iteration, this.repeatCompanionValue, this.backoff);
    }
}

