/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import java.util.concurrent.atomic.AtomicInteger;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.routing.CouldNotRouteOutboundMessageException;
import org.mule.runtime.core.api.routing.RoutingException;
import org.mule.runtime.core.privileged.routing.outbound.AbstractOutboundRouter;

public class RoundRobin
extends AbstractOutboundRouter {
    AtomicInteger index = new AtomicInteger(1);

    @Override
    public InternalEvent route(InternalEvent event) throws MuleException {
        int modulo = this.getAndIncrementModuloN(this.routes.size());
        if (modulo < 0) {
            throw new CouldNotRouteOutboundMessageException(this);
        }
        Processor mp = (Processor)this.routes.get(modulo);
        try {
            return this.doProcessRoute(mp, event);
        }
        catch (MuleException ex) {
            throw new RoutingException(this, ex);
        }
    }

    private int getAndIncrementModuloN(int modulus) {
        int nextIndex;
        int lastIndex;
        if (modulus == 0) {
            return -1;
        }
        while (!this.index.compareAndSet(lastIndex = this.index.get(), nextIndex = (lastIndex + 1) % modulus)) {
        }
        return nextIndex;
    }

    @Override
    public boolean isMatch(InternalEvent message, InternalEvent.Builder builder) throws MuleException {
        return true;
    }
}

