/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.internal;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.beanutils.BeanPropertyValueEqualsPredicate;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.api.util.FileUtils;
import org.mule.runtime.deployment.model.api.DeploymentException;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.deployment.model.api.domain.Domain;
import org.mule.runtime.module.deployment.api.DeploymentListener;
import org.mule.runtime.module.deployment.internal.ArchiveDeployer;
import org.mule.runtime.module.deployment.internal.util.ObservableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainBundleArchiveDeployer {
    protected static Logger LOGGER = LoggerFactory.getLogger(DomainBundleArchiveDeployer.class);
    private final DeploymentListener deploymentListener;
    private final ArchiveDeployer<Domain> domainDeployer;
    private final ObservableList<Domain> domains;
    private final ArchiveDeployer<Application> applicationDeployer;
    private final ObservableList<Application> applications;

    public DomainBundleArchiveDeployer(DeploymentListener deploymentListener, ArchiveDeployer<Domain> domainDeployer, ObservableList<Domain> domains, ArchiveDeployer<Application> applicationDeployer, ObservableList<Application> applications) {
        this.deploymentListener = deploymentListener;
        this.domainDeployer = domainDeployer;
        this.domains = domains;
        this.applicationDeployer = applicationDeployer;
        this.applications = applications;
    }

    public void deployArtifact(URI uri) throws DeploymentException {
        File bundleFile = new File(uri);
        String bundleName = StringUtils.removeEndIgnoreCase((String)bundleFile.getName(), (String)".zip");
        this.deploymentListener.onDeploymentStart(bundleName);
        File tempFolder = null;
        try {
            tempFolder = this.unzipDomainBundle(bundleFile);
            try {
                this.deployDomain(tempFolder);
            }
            catch (Exception e) {
                LOGGER.warn("Domain bundle's domain was not deployed", (Throwable)e);
            }
            this.deployApplications(tempFolder);
            this.deploymentListener.onDeploymentSuccess(bundleName);
        }
        catch (Exception e) {
            this.deploymentListener.onDeploymentFailure(bundleName, e);
            if (e instanceof DeploymentException) {
                throw (DeploymentException)((Object)e);
            }
            throw new DeploymentException(I18nMessageFactory.createStaticMessage((String)"Error deploying domain bundle"), (Throwable)e);
        }
        finally {
            if (tempFolder != null) {
                FileUtils.deleteTree((File)tempFolder);
            }
        }
    }

    private void deployApplications(File tempFolder) {
        File applicationsFolder = new File(tempFolder, "applications");
        if (!applicationsFolder.exists()) {
            throw new DeploymentException(I18nMessageFactory.createStaticMessage((String)"Domain bundle does not contain an application folder"));
        }
        String[] applicationArtifacts = applicationsFolder.list((FilenameFilter)new SuffixFileFilter(".jar"));
        if (applicationArtifacts == null) {
            throw new DeploymentException(I18nMessageFactory.createStaticMessage((String)"Domain bundle does not contain applications"));
        }
        HashSet<String> deployedApps = new HashSet<String>();
        boolean applicationDeploymentError = false;
        for (String applicationArtifact : applicationArtifacts) {
            try {
                this.deployApplication(applicationsFolder, deployedApps, applicationArtifact);
            }
            catch (Exception e) {
                applicationDeploymentError = true;
            }
        }
        if (applicationDeploymentError) {
            throw new DeploymentException(I18nMessageFactory.createStaticMessage((String)"There was an error deploying the bundled applications"));
        }
    }

    private void deployApplication(File applicationsFolder, Set<String> deployedApps, String applicationArtifact) {
        String applicationName = FilenameUtils.getBaseName((String)applicationArtifact);
        deployedApps.add(applicationName);
        Application application = this.findApplication(applicationName);
        if (application != null) {
            this.applicationDeployer.redeploy(application, Optional.empty());
        } else {
            this.applicationDeployer.deployPackagedArtifact(new File(applicationsFolder, applicationArtifact).toURI(), Optional.empty());
        }
    }

    private void deployDomain(File tempFolder) throws IOException {
        File sourceDomainFolder = new File(tempFolder, "domain");
        String[] domainFileNames = sourceDomainFolder.list((FilenameFilter)new SuffixFileFilter(".jar"));
        if (domainFileNames == null) {
            throw new DeploymentException(I18nMessageFactory.createStaticMessage((String)"Domain bundle does not contain a domain artifact"));
        }
        File domainFile = new File(sourceDomainFolder, domainFileNames[0]);
        String domainName = FilenameUtils.getBaseName((String)domainFileNames[0]);
        Domain domain = this.findDomain(domainName);
        if (domain != null) {
            this.domainDeployer.undeployArtifact(domainName);
            FileUtils.unzip((File)domainFile, (File)domain.getLocation());
        }
        this.domainDeployer.deployPackagedArtifact(domainFile.toURI(), Optional.empty());
    }

    private File unzipDomainBundle(File bundleFile) throws IOException {
        File tempFolder = File.createTempFile(bundleFile.getName(), "tmp");
        tempFolder.delete();
        tempFolder.mkdirs();
        FileUtils.unzip((File)bundleFile, (File)tempFolder);
        bundleFile.delete();
        return tempFolder;
    }

    private Domain findDomain(String domainName) {
        return (Domain)CollectionUtils.find(this.domains, (Predicate)new BeanPropertyValueEqualsPredicate("artifactName", (Object)domainName));
    }

    private Application findApplication(String appName) {
        return (Application)CollectionUtils.find(this.applications, (Predicate)new BeanPropertyValueEqualsPredicate("artifactName", (Object)appName));
    }
}

