/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Scannable;
import reactor.core.publisher.ImmutableSignal;
import reactor.core.publisher.InnerConsumer;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoOperator;
import reactor.core.publisher.Operators;
import reactor.core.publisher.Signal;
import reactor.core.publisher.SignalType;
import reactor.core.scheduler.Scheduler;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.annotation.Nullable;

class MonoCacheTime<T>
extends MonoOperator<T, T>
implements Runnable {
    private static final Logger LOGGER = Loggers.getLogger(MonoCacheTime.class);
    final Duration ttl;
    final Scheduler clock;
    volatile Signal<T> state;
    static final AtomicReferenceFieldUpdater<MonoCacheTime, Signal> STATE = AtomicReferenceFieldUpdater.newUpdater(MonoCacheTime.class, Signal.class, "state");
    static final Signal<?> EMPTY = new ImmutableSignal<Object>(SignalType.ON_NEXT, null, null, null);

    MonoCacheTime(Mono<? extends T> source, Duration ttl, Scheduler clock) {
        super(source);
        this.ttl = ttl;
        this.clock = clock;
        this.state = EMPTY;
    }

    @Override
    public void run() {
        LOGGER.debug("expired {}", this.state);
        this.state = EMPTY;
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        block6: {
            Signal<T> state;
            block7: {
                CacheMonoSubscriber<? super T> inner;
                while (true) {
                    if ((state = this.state) == EMPTY) {
                        CoordinatorSubscriber newState = new CoordinatorSubscriber(this);
                        if (!STATE.compareAndSet(this, EMPTY, newState)) continue;
                        this.source.subscribe(newState);
                        inner = new CacheMonoSubscriber<T>(actual, newState);
                        if (!newState.add(inner)) continue;
                        actual.onSubscribe(inner);
                        break block6;
                    }
                    if (!(state instanceof CoordinatorSubscriber)) break block7;
                    CoordinatorSubscriber coordinator = (CoordinatorSubscriber)state;
                    inner = new CacheMonoSubscriber<T>(actual, coordinator);
                    if (coordinator.add(inner)) break;
                }
                actual.onSubscribe(inner);
                break block6;
            }
            if (state.isOnNext()) {
                actual.onSubscribe(new Operators.ScalarSubscription<T>(actual, state.get()));
            } else if (state.isOnComplete()) {
                Operators.complete(actual);
            } else {
                Operators.error(actual, state.getThrowable());
            }
        }
    }

    static final class CacheMonoSubscriber<T>
    extends Operators.MonoSubscriber<T, T> {
        final CoordinatorSubscriber<T> coordinator;

        CacheMonoSubscriber(CoreSubscriber<? super T> actual, CoordinatorSubscriber<T> coordinator) {
            super(actual);
            this.coordinator = coordinator;
        }

        @Override
        public void cancel() {
            super.cancel();
            this.coordinator.remove(this);
        }
    }

    static final class CoordinatorSubscriber<T>
    implements InnerConsumer<T>,
    Signal<T> {
        final MonoCacheTime<T> main;
        volatile Subscription subscription;
        static final AtomicReferenceFieldUpdater<CoordinatorSubscriber, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(CoordinatorSubscriber.class, Subscription.class, "subscription");
        volatile Operators.MonoSubscriber<T, T>[] subscribers;
        static final AtomicReferenceFieldUpdater<CoordinatorSubscriber, Operators.MonoSubscriber[]> SUBSCRIBERS = AtomicReferenceFieldUpdater.newUpdater(CoordinatorSubscriber.class, Operators.MonoSubscriber[].class, "subscribers");
        private static final Operators.MonoSubscriber[] TERMINATED = new Operators.MonoSubscriber[0];
        private static final Operators.MonoSubscriber[] EMPTY = new Operators.MonoSubscriber[0];

        CoordinatorSubscriber(MonoCacheTime<T> main) {
            this.main = main;
            this.subscribers = EMPTY;
        }

        @Override
        public Throwable getThrowable() {
            throw new UnsupportedOperationException("illegal signal use");
        }

        @Override
        public Subscription getSubscription() {
            throw new UnsupportedOperationException("illegal signal use");
        }

        @Override
        public T get() {
            throw new UnsupportedOperationException("illegal signal use");
        }

        @Override
        public SignalType getType() {
            throw new UnsupportedOperationException("illegal signal use");
        }

        final boolean add(Operators.MonoSubscriber<T, T> toAdd) {
            Operators.MonoSubscriber[] b;
            Operators.MonoSubscriber<T, T>[] a;
            do {
                if ((a = this.subscribers) == TERMINATED) {
                    return false;
                }
                int n = a.length;
                b = new Operators.MonoSubscriber[n + 1];
                System.arraycopy(a, 0, b, 0, n);
                b[n] = toAdd;
            } while (!SUBSCRIBERS.compareAndSet(this, a, b));
            return true;
        }

        final void remove(Operators.MonoSubscriber<T, T> toRemove) {
            Operators.MonoSubscriber[] b;
            Operators.MonoSubscriber<T, T>[] a;
            do {
                if ((a = this.subscribers) == TERMINATED || a == EMPTY) {
                    return;
                }
                int n = a.length;
                int j = -1;
                for (int i = 0; i < n; ++i) {
                    if (a[i] != toRemove) continue;
                    j = i;
                    break;
                }
                if (j < 0) {
                    return;
                }
                if (n == 1) {
                    b = EMPTY;
                    continue;
                }
                b = new Operators.MonoSubscriber[n - 1];
                System.arraycopy(a, 0, b, 0, j);
                System.arraycopy(a, j + 1, b, j, n - j - 1);
            } while (!SUBSCRIBERS.compareAndSet(this, a, b));
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.subscription, s)) {
                this.subscription = s;
                s.request(Long.MAX_VALUE);
            }
        }

        private void signalCached(Signal<T> signal) {
            if (STATE.compareAndSet(this.main, this, signal)) {
                this.main.clock.schedule(this.main, this.main.ttl.toMillis(), TimeUnit.MILLISECONDS);
            }
            for (Operators.MonoSubscriber inner : SUBSCRIBERS.getAndSet(this, TERMINATED)) {
                if (signal.isOnNext()) {
                    inner.complete(signal.get());
                    continue;
                }
                if (signal.isOnError()) {
                    inner.onError(signal.getThrowable());
                    continue;
                }
                inner.onComplete();
            }
        }

        public void onNext(T t) {
            if (this.main.state != this) {
                Operators.onNextDroppedMulticast(t);
                return;
            }
            this.signalCached(Signal.next(t));
        }

        public void onError(Throwable t) {
            if (this.main.state != this) {
                Operators.onErrorDroppedMulticast(t);
                return;
            }
            this.signalCached(Signal.error(t));
        }

        public void onComplete() {
            this.signalCached(Signal.complete());
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            return null;
        }
    }
}

