/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.enricher;

import javax.xml.namespace.QName;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.model.declaration.fluent.ComponentDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExecutableComponentDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.extension.api.declaration.fluent.util.IdempotentDeclarationWalker;
import org.mule.runtime.extension.api.declaration.type.StreamingStrategyTypeBuilder;
import org.mule.runtime.extension.api.loader.DeclarationEnricher;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.util.XmlModelUtils;
import org.mule.runtime.extension.internal.loader.util.InfrastructureParameterBuilder;
import org.mule.runtime.extension.internal.property.PagedOperationModelProperty;

public class StreamingDeclarationEnricher
implements DeclarationEnricher {
    @Override
    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        new IdempotentDeclarationWalker(){

            @Override
            protected void onOperation(OperationDeclaration declaration) {
                StreamingDeclarationEnricher.this.enrich((ExecutableComponentDeclaration)declaration);
            }

            @Override
            protected void onSource(SourceDeclaration declaration) {
                StreamingDeclarationEnricher.this.enrich((ExecutableComponentDeclaration)declaration);
            }
        }.walk((ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration());
    }

    private void enrich(ExecutableComponentDeclaration declaration) {
        if (declaration.isSupportsStreaming()) {
            QName qName;
            MetadataType type;
            if (declaration.getModelProperty(PagedOperationModelProperty.class).isPresent()) {
                type = new StreamingStrategyTypeBuilder().getObjectStreamingStrategyType();
                qName = XmlModelUtils.MULE_ABSTRACT_OBJECT_STREAMING_STRATEGY_QNAME;
            } else {
                type = new StreamingStrategyTypeBuilder().getByteStreamingStrategyType();
                qName = XmlModelUtils.MULE_ABSTRACT_BYTE_STREAMING_STRATEGY_QNAME;
            }
            InfrastructureParameterBuilder.addStreamingParameter((ComponentDeclaration)declaration, type, qName);
        }
    }
}

