/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.declaration.fluent.Declarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ExecutableComponentDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasModelProperties;
import org.mule.runtime.api.meta.model.declaration.fluent.HasOperationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasParametersDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.NamedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclarer;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.annotation.execution.Execution;
import org.mule.runtime.extension.api.connectivity.TransactionalConnection;
import org.mule.runtime.extension.api.exception.IllegalOperationModelDefinitionException;
import org.mule.runtime.extension.api.exception.IllegalParameterModelDefinitionException;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.internal.property.PagedOperationModelProperty;
import org.mule.runtime.module.extension.api.loader.java.property.ComponentExecutorModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.AbstractModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.DefaultJavaModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.RouterModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.ScopeModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.property.FieldOperationParameterModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingMethodModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.internal.loader.java.type.MethodElement;
import org.mule.runtime.module.extension.internal.loader.java.type.OperationContainerElement;
import org.mule.runtime.module.extension.internal.loader.java.type.WithOperationContainers;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.ParameterizableTypeWrapper;
import org.mule.runtime.module.extension.internal.loader.utils.ModelLoaderUtils;
import org.mule.runtime.module.extension.internal.loader.utils.ParameterDeclarationContext;
import org.mule.runtime.module.extension.internal.runtime.execution.ReflectiveOperationExecutorFactory;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.springframework.core.ResolvableType;

final class OperationModelLoaderDelegate
extends AbstractModelLoaderDelegate {
    private static final String OPERATION = "Operation";
    private final Map<MethodElement, OperationDeclarer> operationDeclarers = new HashMap<MethodElement, OperationDeclarer>();
    private final ScopeModelLoaderDelegate scopesDelegate;
    private final RouterModelLoaderDelegate routersDelegate;

    OperationModelLoaderDelegate(DefaultJavaModelLoaderDelegate delegate) {
        super(delegate);
        this.scopesDelegate = new ScopeModelLoaderDelegate(delegate);
        this.routersDelegate = new RouterModelLoaderDelegate(delegate);
    }

    void declareOperations(ExtensionDeclarer extensionDeclarer, HasOperationDeclarer declarer, WithOperationContainers operationContainers) {
        operationContainers.getOperationContainers().forEach(operationContainer -> this.declareOperations(extensionDeclarer, declarer, (OperationContainerElement)operationContainer));
    }

    void declareOperations(ExtensionDeclarer extensionDeclarer, HasOperationDeclarer declarer, OperationContainerElement operationsContainer) {
        this.declareOperations(extensionDeclarer, declarer, operationsContainer.getDeclaringClass(), operationsContainer.getOperations(), true);
    }

    void declareOperations(ExtensionDeclarer extensionDeclarer, HasOperationDeclarer ownerDeclarer, Class<?> methodOwnerClass, List<MethodElement> operations, boolean supportsConfig) {
        for (MethodElement operationMethod : operations) {
            Class declaringClass = methodOwnerClass != null ? methodOwnerClass : operationMethod.getDeclaringClass();
            this.checkOperationIsNotAnExtension(declaringClass);
            Method method = operationMethod.getMethod();
            Optional<ExtensionParameter> configParameter = this.loader.getConfigParameter(operationMethod);
            Optional<ExtensionParameter> connectionParameter = this.loader.getConnectionParameter(operationMethod);
            if (ModelLoaderUtils.isScope(operationMethod)) {
                this.scopesDelegate.declareScope(extensionDeclarer, ownerDeclarer, methodOwnerClass, operationMethod, method, configParameter, connectionParameter);
                continue;
            }
            if (ModelLoaderUtils.isRouter(operationMethod)) {
                this.routersDelegate.declareRouter(extensionDeclarer, ownerDeclarer, methodOwnerClass, operationMethod, method, configParameter, connectionParameter);
                continue;
            }
            OperationModelLoaderDelegate.checkDefinition(!this.loader.isInvalidConfigSupport(supportsConfig, configParameter, connectionParameter), String.format("Operation '%s' is defined at the extension level but it requires a config. Remove such parameter or move the operation to the proper config", method.getName()));
            HasOperationDeclarer actualDeclarer = this.selectDeclarer(extensionDeclarer, (Declarer)ownerDeclarer, operationMethod, configParameter, connectionParameter);
            if (this.operationDeclarers.containsKey(operationMethod)) {
                actualDeclarer.withOperation(this.operationDeclarers.get(operationMethod));
                continue;
            }
            OperationDeclarer operationDeclarer = (OperationDeclarer)((OperationDeclarer)actualDeclarer.withOperation(operationMethod.getAlias()).withModelProperty((ModelProperty)new ImplementingMethodModelProperty(method))).withModelProperty((ModelProperty)new ComponentExecutorModelProperty(new ReflectiveOperationExecutorFactory(declaringClass, method)));
            this.loader.addExceptionEnricher(operationMethod, (HasModelProperties)operationDeclarer);
            List<ExtensionParameter> fieldParameters = new ParameterizableTypeWrapper(declaringClass).getParameters();
            this.declareParameters(operationDeclarer, supportsConfig, operationMethod, fieldParameters, method);
            this.operationDeclarers.put(operationMethod, operationDeclarer);
        }
    }

    private void declareParameters(OperationDeclarer operation, boolean supportsConfig, MethodElement operationMethod, List<ExtensionParameter> fieldParameters, Method method) {
        this.processComponentConnectivity((ExecutableComponentDeclarer)operation, operationMethod, operationMethod);
        if (ModelLoaderUtils.isNonBlocking(operationMethod)) {
            OperationModelLoaderDelegate.processNonBlockingOperation(operation, operationMethod, true, this.loader.getTypeLoader());
        } else {
            this.processBlockingOperation(supportsConfig, operationMethod, method, operation);
        }
        this.processMimeType((HasModelProperties)operation, operationMethod);
        this.addExecutionType(operation, operationMethod);
        ParameterDeclarationContext declarationContext = new ParameterDeclarationContext(OPERATION, (NamedDeclaration)operation.getDeclaration());
        this.loader.getMethodParametersLoader().declare((HasParametersDeclarer)operation, operationMethod.getParameters(), declarationContext);
        this.loader.getFieldParametersLoader().declare((HasParametersDeclarer)operation, fieldParameters, declarationContext).forEach(p -> {
            p.withExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
            p.withModelProperty((ModelProperty)new FieldOperationParameterModelProperty());
        });
    }

    private void processBlockingOperation(boolean supportsConfig, MethodElement operationMethod, Method method, OperationDeclarer operation) {
        operation.blocking(true);
        operation.withOutputAttributes().ofType(IntrospectionUtils.getMethodReturnAttributesType(method, this.loader.getTypeLoader()));
        MetadataType outputType = IntrospectionUtils.getMethodReturnType(method, this.loader.getTypeLoader());
        if (ModelLoaderUtils.isAutoPaging(operationMethod)) {
            ((OperationDeclarer)operation.supportsStreaming(true)).withOutput().ofType(outputType);
            this.addPagedOperationModelProperty(operationMethod, operation, supportsConfig);
            this.processPagingTx(operation, method);
        } else {
            operation.withOutput().ofType(outputType);
            ModelLoaderUtils.handleByteStreaming(method, (ExecutableComponentDeclarer)operation, outputType);
        }
    }

    private HasOperationDeclarer selectDeclarer(ExtensionDeclarer extensionDeclarer, Declarer declarer, MethodElement operationMethod, Optional<ExtensionParameter> configParameter, Optional<ExtensionParameter> connectionParameter) {
        if (ModelLoaderUtils.isAutoPaging(operationMethod)) {
            return (HasOperationDeclarer)declarer;
        }
        return (HasOperationDeclarer)this.loader.selectDeclarerBasedOnConfig(extensionDeclarer, declarer, configParameter, connectionParameter);
    }

    static void processNonBlockingOperation(OperationDeclarer operation, MethodElement operationMethod, boolean allowStreaming, ClassTypeLoader typeLoader) {
        List callbackParameters = operationMethod.getParameters().stream().filter(p -> CompletionCallback.class.equals((Object)p.getType().getDeclaringClass())).collect(Collectors.toList());
        OperationModelLoaderDelegate.checkDefinition(!callbackParameters.isEmpty(), String.format("Operation '%s' does not declare a '%s' parameter. One is required for a non-blocking operation", operationMethod.getAlias(), CompletionCallback.class.getSimpleName()));
        OperationModelLoaderDelegate.checkDefinition(callbackParameters.size() <= 1, String.format("Operation '%s' defines more than one %s parameters. Only one is allowed", operationMethod.getAlias(), CompletionCallback.class.getSimpleName()));
        OperationModelLoaderDelegate.checkDefinition(IntrospectionUtils.isVoid(operationMethod.getMethod()), String.format("Operation '%s' has a parameter of type %s but is not void. Non-blocking operations have to be declared as void and the return type provided through the callback", operationMethod.getAlias(), CompletionCallback.class.getSimpleName()));
        ExtensionParameter callbackParameter = (ExtensionParameter)callbackParameters.get(0);
        Parameter methodParameter = (Parameter)callbackParameter.getDeclaringElement();
        List<MetadataType> genericTypes = IntrospectionUtils.getGenerics(methodParameter.getParameterizedType(), typeLoader);
        if (genericTypes.isEmpty()) {
            throw new IllegalParameterModelDefinitionException(String.format("Generics are mandatory on the %s parameter of Operation '%s'", CompletionCallback.class.getSimpleName(), operationMethod.getAlias()));
        }
        operation.withOutput().ofType(genericTypes.get(0));
        operation.withOutputAttributes().ofType(genericTypes.get(1));
        operation.blocking(false);
        if (allowStreaming) {
            ModelLoaderUtils.handleByteStreaming(operationMethod.getMethod(), (ExecutableComponentDeclarer)operation, genericTypes.get(0));
        } else {
            operation.supportsStreaming(false);
        }
    }

    private void addExecutionType(OperationDeclarer operationDeclarer, MethodElement operationMethod) {
        operationMethod.getAnnotation(Execution.class).ifPresent(a -> operationDeclarer.withExecutionType(a.value()));
    }

    private void checkOperationIsNotAnExtension(Class<?> operationType) {
        if (operationType.isAssignableFrom(this.getExtensionType()) || this.getExtensionType().isAssignableFrom(operationType)) {
            throw new IllegalOperationModelDefinitionException(String.format("Operation class '%s' cannot be the same class (nor a derivative) of the extension class '%s", operationType.getName(), this.getExtensionType().getName()));
        }
    }

    private void addPagedOperationModelProperty(MethodElement operationMethod, OperationDeclarer operation, boolean supportsConfig) {
        OperationModelLoaderDelegate.checkDefinition(supportsConfig, String.format("Paged operation '%s' is defined at the extension level but it requires a config, since connections are required for paging", operationMethod.getName()));
        operation.withModelProperty((ModelProperty)new PagedOperationModelProperty());
        operation.requiresConnection(true);
    }

    private void processPagingTx(OperationDeclarer operation, Method method) {
        Preconditions.checkArgument((method != null ? 1 : 0) != 0, (String)"Can't introspect a null method");
        ResolvableType connectionType = (ResolvableType)IntrospectionUtils.getPagingProviderTypes(ResolvableType.forMethodReturnType((Method)method)).getFirst();
        operation.transactional(TransactionalConnection.class.isAssignableFrom(connectionType.getRawClass()));
    }

    static void checkDefinition(boolean condition, String message) {
        if (!condition) {
            throw new IllegalOperationModelDefinitionException(message);
        }
    }
}

