/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java.type.runtime;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.module.extension.internal.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.internal.loader.java.type.MethodElement;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.ParameterWrapper;
import org.springframework.core.ResolvableType;

public final class MethodWrapper
implements MethodElement {
    private final Method method;

    public MethodWrapper(Method method) {
        this.method = method;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public Class getDeclaringClass() {
        return this.method.getDeclaringClass();
    }

    @Override
    public List<ExtensionParameter> getParameters() {
        Parameter[] parameters = this.method.getParameters();
        ArrayList<ExtensionParameter> extensionParameters = new ArrayList<ExtensionParameter>(parameters.length);
        for (int i = 0; i < parameters.length; ++i) {
            extensionParameters.add(new ParameterWrapper(this.method, i));
        }
        return extensionParameters;
    }

    @Override
    public List<ExtensionParameter> getParameterGroups() {
        return this.getParametersAnnotatedWith(ParameterGroup.class);
    }

    @Override
    public List<ExtensionParameter> getParametersAnnotatedWith(Class<? extends Annotation> annotationClass) {
        LinkedList<ExtensionParameter> extensionParameters = new LinkedList<ExtensionParameter>();
        Parameter[] parameters = this.method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            if (parameters[i].getAnnotation(annotationClass) == null) continue;
            extensionParameters.add(new ParameterWrapper(this.method, i));
        }
        return extensionParameters;
    }

    @Override
    public String getName() {
        return this.method.getName();
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.method.getAnnotations();
    }

    @Override
    public <A extends Annotation> Optional<A> getAnnotation(Class<A> annotationClass) {
        return Optional.ofNullable(this.method.getAnnotation(annotationClass));
    }

    @Override
    public Class<?> getReturnType() {
        return ResolvableType.forMethodReturnType((Method)this.method).getRawClass();
    }

    public boolean equals(Object obj) {
        return obj instanceof MethodElement && this.method.equals(((MethodElement)obj).getMethod());
    }

    public int hashCode() {
        return this.method.hashCode();
    }
}

