/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.meta.model.stereotype;

import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.api.util.NameUtils;
import org.mule.runtime.api.util.Preconditions;

public final class ImmutableStereotypeModel
implements StereotypeModel {
    private String type;
    private String namespace;
    private StereotypeModel parent;

    public ImmutableStereotypeModel(String name, String namespace, StereotypeModel parent) {
        Preconditions.checkArgument(StringUtils.isNotBlank((CharSequence)name), "An stereotype name is required");
        Preconditions.checkArgument(StringUtils.isNotBlank((CharSequence)namespace), "An stereotype namespace is required");
        this.type = this.normalize(name);
        this.namespace = this.normalize(namespace);
        this.parent = parent;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public Optional<StereotypeModel> getParent() {
        return Optional.ofNullable(this.parent);
    }

    @Override
    public boolean isAssignableTo(StereotypeModel other) {
        Preconditions.checkArgument(other != null, "Null is not a valid stereotype");
        boolean assignable = this.equals(other);
        if (!assignable && this.parent != null) {
            assignable = this.parent.isAssignableTo(other);
        }
        return assignable;
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public String toString() {
        return this.namespace + ":" + this.type + (this.parent == null ? "" : "(" + this.parent.toString() + ")");
    }

    private String normalize(String name) {
        return NameUtils.sanitizeName(NameUtils.underscorize(name)).toUpperCase();
    }
}

