/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.metadata;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import org.mule.metadata.internal.utils.StringUtils;

public final class MediaType
implements Serializable {
    private static final long serialVersionUID = -3626429370741009489L;
    private static final String CHARSET_PARAM = "charset";
    private static final String TYPE_TEXT = "text";
    private static final String TYPE_APPLICATION = "application";
    private static final String TYPE_MULTIPART = "multipart";
    private static final String SUBTYPE_JSON = "json";
    private static final String SUBTYPE_XML = "xml";
    private static final String SUBTYPE_PLAIN = "plain";
    private static final String SUBTYPE_HTML = "html";
    private static final String SUBTYPE_OCTET_STREAM = "octet-stream";
    private static final String SUBTYPE_MIXED = "mixed";
    private static final String SUBTYPE_FORM_DATA = "form-data";
    private static final String SUBTYPE_RELATED = "related";
    public static final MediaType ANY = MediaType.create("*", "*");
    public static final MediaType JSON = MediaType.create("text", "json");
    public static final MediaType APPLICATION_JSON = MediaType.create("application", "json");
    public static final MediaType APPLICATION_JAVA = MediaType.create("application", "java");
    public static final MediaType ATOM = MediaType.create("application", "atom+xml");
    public static final MediaType RSS = MediaType.create("application", "rss+xml");
    public static final MediaType APPLICATION_XML = MediaType.create("application", "xml");
    public static final MediaType XML = MediaType.create("text", "xml");
    public static final MediaType TEXT = MediaType.create("text", "plain");
    public static final MediaType HTML = MediaType.create("text", "html");
    public static final MediaType BINARY = MediaType.create("application", "octet-stream");
    public static final MediaType UNKNOWN = MediaType.create("content", "unknown");
    public static final MediaType MULTIPART_MIXED = MediaType.create("multipart", "mixed");
    public static final MediaType MULTIPART_FORM_DATA = MediaType.create("multipart", "form-data");
    public static final MediaType MULTIPART_RELATED = MediaType.create("multipart", "related");
    public static final MediaType MULTIPART_X_MIXED_REPLACE = MediaType.create("multipart", "x-mixed-replace");
    private final String primaryType;
    private final String subType;
    private final Map<String, String> params;
    private transient Charset charset;

    public static MediaType parse(String mediaType) {
        try {
            MimeType mimeType = new MimeType(mediaType);
            String charsetParam = mimeType.getParameter(CHARSET_PARAM);
            Charset charset = StringUtils.isNotEmpty((String)charsetParam) ? Charset.forName(charsetParam) : null;
            HashMap<String, String> params = new HashMap<String, String>();
            for (String paramName : Collections.list(mimeType.getParameters().getNames())) {
                if (CHARSET_PARAM.equals(paramName)) continue;
                params.put(paramName, mimeType.getParameter(paramName));
            }
            return new MediaType(mimeType.getPrimaryType(), mimeType.getSubType(), params, charset);
        }
        catch (MimeTypeParseException e) {
            throw new IllegalArgumentException("MediaType cannot be parsed: " + mediaType, e);
        }
    }

    public static MediaType create(String primaryType, String subType) {
        return new MediaType(primaryType, subType, Collections.emptyMap(), null);
    }

    public static MediaType create(String primaryType, String subType, Charset charset) {
        return new MediaType(primaryType, subType, Collections.emptyMap(), charset);
    }

    private MediaType(String primaryType, String subType, Map<String, String> params, Charset charset) {
        this.primaryType = primaryType;
        this.subType = subType;
        this.params = params;
        this.charset = charset;
    }

    public MediaType withCharset(Charset charset) {
        return new MediaType(this.getPrimaryType(), this.getSubType(), this.params, charset);
    }

    public MediaType withoutParameters() {
        return MediaType.create(this.getPrimaryType(), this.getSubType());
    }

    public String getPrimaryType() {
        return this.primaryType;
    }

    public String getSubType() {
        return this.subType;
    }

    public Optional<Charset> getCharset() {
        return Optional.ofNullable(this.charset);
    }

    public String getParameter(String paramName) {
        return this.params.get(paramName);
    }

    public boolean matches(MediaType other) {
        return Objects.equals(this.primaryType, other.primaryType) && Objects.equals(this.subType, other.subType);
    }

    public String toRfcString() {
        StringBuilder buffer = new StringBuilder();
        this.params.forEach((k, v) -> buffer.append("; " + k + "=\"" + v + "\""));
        return this.primaryType + "/" + this.subType + (this.getCharset().isPresent() ? "; charset=" + this.getCharset().get().name() : "") + (!this.params.isEmpty() ? buffer.toString() : "");
    }

    public String toString() {
        return this.toRfcString();
    }

    public int hashCode() {
        return Objects.hash(this.primaryType, this.subType, this.charset, this.params);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        MediaType other = (MediaType)obj;
        return Objects.equals(this.primaryType, other.primaryType) && Objects.equals(this.subType, other.subType) && Objects.equals(this.params, other.params) && Objects.equals(this.charset, other.charset);
    }

    private void readObject(ObjectInputStream in) throws Exception {
        in.defaultReadObject();
        String charsetStr = (String)in.readObject();
        if (charsetStr != null) {
            this.charset = Charset.forName(charsetStr);
        }
    }

    private void writeObject(ObjectOutputStream out) throws Exception {
        out.defaultWriteObject();
        if (this.charset != null) {
            out.writeObject(this.charset.name());
        } else {
            out.writeObject(null);
        }
    }
}

