/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal.executor;

import java.util.Set;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.scheduler.SchedulerBusyException;
import org.mule.service.scheduler.internal.DefaultSchedulerService;
import org.mule.service.scheduler.internal.executor.AbstractByCallerPolicy;
import org.mule.service.scheduler.internal.executor.WaitPolicy;
import org.mule.service.scheduler.internal.threads.SchedulerThreadFactory;

public final class ByCallerThreadGroupPolicy
extends AbstractByCallerPolicy
implements RejectedExecutionHandler {
    private final ThreadPoolExecutor.AbortPolicy abort = new AbortBusyPolicy();
    private final WaitPolicy wait = new WaitPolicy(this.abort);
    private final ThreadPoolExecutor.CallerRunsPolicy callerRuns = new ThreadPoolExecutor.CallerRunsPolicy();
    private volatile long rejectedCount;

    public ByCallerThreadGroupPolicy(Set<ThreadGroup> waitGroups, ThreadGroup parentGroup) {
        super(waitGroups, parentGroup);
    }

    @Override
    public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
        ThreadGroup targetGroup = ((SchedulerThreadFactory)executor.getThreadFactory()).getGroup();
        ThreadGroup currentThreadGroup = Thread.currentThread().getThreadGroup();
        ++this.rejectedCount;
        if (this.isWaitGroupThread(targetGroup) && targetGroup == currentThreadGroup) {
            this.logRejection(r.toString(), this.callerRuns.getClass().getSimpleName(), targetGroup.getName());
            this.callerRuns.rejectedExecution(r, executor);
        } else if (!this.isSchedulerThread(currentThreadGroup) || this.isWaitGroupThread(currentThreadGroup)) {
            this.logRejection(r.toString(), this.wait.getClass().getSimpleName(), targetGroup.getName());
            this.wait.rejectedExecution(r, executor);
        } else {
            this.logRejection(r.toString(), this.abort.getClass().getSimpleName(), targetGroup.getName());
            this.abort.rejectedExecution(r, executor);
        }
    }

    private void logRejection(String taskAsString, String strategy, String targetAsString) {
        if (DefaultSchedulerService.USAGE_TRACE_INTERVAL_SECS != null) {
            DefaultSchedulerService.traceLogger.warn("Task rejected ({}) from '{}' scheduler: {}", new Object[]{StringUtils.rightPad((String)strategy, (int)16), targetAsString, taskAsString});
        } else if (DefaultSchedulerService.traceLogger.isDebugEnabled()) {
            DefaultSchedulerService.traceLogger.debug("Task rejected ({}) from '{}' scheduler: {}", new Object[]{StringUtils.rightPad((String)strategy, (int)16), targetAsString, taskAsString});
        }
    }

    public long getRejectedCount() {
        return this.rejectedCount;
    }

    private static final class AbortBusyPolicy
    extends ThreadPoolExecutor.AbortPolicy {
        private AbortBusyPolicy() {
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            throw new SchedulerBusyException("Task '" + r.toString() + "' rejected from '" + executor.toString() + "'");
        }
    }
}

