/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.model;

import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.config.api.LazyComponentInitializer;
import org.mule.runtime.config.internal.dsl.model.ConfigurationDependencyResolver;
import org.mule.runtime.config.internal.model.ApplicationModel;
import org.mule.runtime.config.internal.model.ComponentModel;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;

public class MinimalApplicationModelGenerator {
    private ConfigurationDependencyResolver dependencyResolver;

    public MinimalApplicationModelGenerator(ConfigurationDependencyResolver dependencyResolver) {
        this.dependencyResolver = dependencyResolver;
    }

    public ApplicationModel getMinimalModel(LazyComponentInitializer.ComponentLocationFilter filter) {
        List<ComponentModel> required = this.dependencyResolver.findRequiredComponentModels(filter);
        required.stream().forEach(componentModel -> {
            DefaultComponentLocation componentLocation = componentModel.getComponentLocation();
            if (componentLocation != null) {
                this.enableComponentDependencies((ComponentModel)componentModel);
            }
        });
        return this.dependencyResolver.getApplicationModel();
    }

    public ApplicationModel getMinimalModel(Location location) {
        ComponentModel requestedComponentModel = this.dependencyResolver.findRequiredComponentModel(location);
        this.enableComponentDependencies(requestedComponentModel);
        return this.dependencyResolver.getApplicationModel();
    }

    private void enableComponentDependencies(ComponentModel requestedComponentModel) {
        String requestComponentModelName = requestedComponentModel.getNameAttribute();
        Set<String> componentDependencies = this.dependencyResolver.resolveComponentDependencies(requestedComponentModel);
        Set<String> alwaysEnabledComponents = this.dependencyResolver.resolveAlwaysEnabledComponents();
        ImmutableSet.Builder otherRequiredGlobalComponentsSetBuilder = ImmutableSet.builder().addAll(componentDependencies).addAll(alwaysEnabledComponents);
        if (requestComponentModelName != null && this.dependencyResolver.getApplicationModel().findTopLevelNamedElement(requestComponentModelName).isPresent()) {
            otherRequiredGlobalComponentsSetBuilder.add((Object)requestComponentModelName);
        }
        Set<String> allRequiredComponentModels = this.resolveDependencies((Set<String>)otherRequiredGlobalComponentsSetBuilder.build());
        for (ComponentModel componentModel2 : this.dependencyResolver.getApplicationModel().getRootComponentModel().getInnerComponents()) {
            if (componentModel2.getNameAttribute() == null || !allRequiredComponentModels.contains(componentModel2.getNameAttribute())) continue;
            componentModel2.setEnabled(true);
            componentModel2.executedOnEveryInnerComponent(component -> component.setEnabled(true));
        }
        for (ComponentModel parentModel = requestedComponentModel.getParent(); parentModel != null && parentModel.getParent() != null; parentModel = parentModel.getParent()) {
            parentModel.setEnabled(true);
        }
        requestedComponentModel.setEnabled(true);
        requestedComponentModel.executedOnEveryInnerComponent(componentModel -> componentModel.setEnabled(true));
        this.dependencyResolver.getApplicationModel().getRootComponentModel().setEnabled(true);
    }

    private Set<String> resolveDependencies(Set<String> initialComponents) {
        Set<String> difference = initialComponents;
        HashSet<String> allRequiredComponentModels = new HashSet<String>(initialComponents);
        while (difference.size() > 0) {
            Set<String> newDependencies = this.dependencyResolver.findComponentModelsDependencies(difference);
            newDependencies.removeAll(allRequiredComponentModels);
            allRequiredComponentModels.addAll(newDependencies);
            difference = newDependencies;
        }
        return allRequiredComponentModels;
    }
}

