/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.context.notification;

import org.mule.runtime.api.notification.AbstractServerNotification;
import org.mule.runtime.core.api.MuleContext;

public class MuleContextNotification
extends AbstractServerNotification {
    private static final long serialVersionUID = -3246036188011581121L;
    public static final int CONTEXT_INITIALISING = 101;
    public static final int CONTEXT_INITIALISED = 102;
    public static final int CONTEXT_STARTING = 103;
    public static final int CONTEXT_STARTED = 104;
    public static final int CONTEXT_STOPPING = 105;
    public static final int CONTEXT_STOPPED = 106;
    public static final int CONTEXT_DISPOSING = 107;
    public static final int CONTEXT_DISPOSED = 108;
    private String clusterId;
    private String domain;
    private transient MuleContext muleContext;

    public MuleContextNotification(MuleContext context, String action) {
        this(context, MuleContextNotification.getActionId((String)action));
    }

    public MuleContextNotification(MuleContext context, int action) {
        super((Object)context.getId(), action);
        this.muleContext = context;
        this.resourceIdentifier = context.getConfiguration().getId();
        this.clusterId = context.getClusterId();
        this.domain = context.getConfiguration().getDomainId();
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String getDomain() {
        return this.domain;
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public String toString() {
        return this.getEventName() + "{action=" + MuleContextNotification.getActionName((int)this.action) + ", resourceId=" + this.resourceIdentifier + ", timestamp=" + this.timestamp + "}";
    }

    public boolean isSynchronous() {
        return true;
    }

    public String getEventName() {
        return "MuleContextNotification";
    }

    static {
        MuleContextNotification.registerAction((String)"mule context initialising", (int)101);
        MuleContextNotification.registerAction((String)"mule context initialised", (int)102);
        MuleContextNotification.registerAction((String)"mule context starting", (int)103);
        MuleContextNotification.registerAction((String)"mule context started", (int)104);
        MuleContextNotification.registerAction((String)"mule context stopping", (int)105);
        MuleContextNotification.registerAction((String)"mule context stopped", (int)106);
        MuleContextNotification.registerAction((String)"mule context disposing", (int)107);
        MuleContextNotification.registerAction((String)"mule context disposed", (int)108);
    }
}

