/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.exception;

import java.util.function.Function;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface FlowExceptionHandler
extends Function<Exception, Publisher<CoreEvent>> {
    public CoreEvent handleException(Exception var1, CoreEvent var2);

    @Override
    default public Publisher<CoreEvent> apply(Exception exception) {
        try {
            if (exception instanceof MessagingException) {
                MessagingException me = (MessagingException)((Object)exception);
                me.setProcessedEvent(this.handleException(exception, me.getEvent()));
                if (me.handled()) {
                    return Mono.just((Object)me.getEvent());
                }
                return Flux.error((Throwable)exception);
            }
            return Flux.error((Throwable)exception);
        }
        catch (Throwable throwable) {
            return Flux.error((Throwable)Exceptions.propagateWrappingFatal(throwable));
        }
    }
}

