/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.interceptor;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.interception.InterceptionEvent;
import org.mule.runtime.api.interception.ProcessorInterceptor;
import org.mule.runtime.api.interception.ProcessorInterceptorFactory;
import org.mule.runtime.api.interception.ProcessorParameterValue;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.component.ComponentAnnotations;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.interception.DefaultInterceptionEvent;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.core.internal.processor.ParametersResolverProcessor;
import org.mule.runtime.core.internal.processor.interceptor.DefaultProcessorParameterValue;
import org.mule.runtime.core.internal.processor.interceptor.InterceptionException;
import org.mule.runtime.core.internal.util.MessagingExceptionResolver;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;

public class ReactiveInterceptorAdapter
implements BiFunction<Processor, ReactiveProcessor, ReactiveProcessor> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReactiveInterceptorAdapter.class);
    private static final String BEFORE_METHOD_NAME = "before";
    private static final String AFTER_METHOD_NAME = "after";
    private static final String INTERCEPTION_COMPONENT = "core:interceptionComponent";
    @Inject
    private MuleContext muleContext;
    @Inject
    private ExtendedExpressionManager expressionManager;
    private ProcessorInterceptorFactory interceptorFactory;

    public ReactiveInterceptorAdapter(ProcessorInterceptorFactory interceptorFactory) {
        this.interceptorFactory = interceptorFactory;
    }

    @Override
    public ReactiveProcessor apply(Processor component, ReactiveProcessor next) {
        if (!this.isInterceptable(component)) {
            return next;
        }
        ComponentLocation componentLocation = ((Component)component).getLocation();
        if (!this.interceptorFactory.intercept(componentLocation)) {
            return next;
        }
        ProcessorInterceptor interceptor = (ProcessorInterceptor)this.interceptorFactory.get();
        Map dslParameters = (Map)((Component)component).getAnnotation(ComponentAnnotations.ANNOTATION_PARAMETERS);
        ReactiveProcessor interceptedProcessor = this.doApply(component, next, componentLocation, interceptor, dslParameters);
        LOGGER.debug("Interceptor '{}' for processor '{}' configured.", (Object)interceptor, (Object)componentLocation.getLocation());
        return interceptedProcessor;
    }

    protected ReactiveProcessor doApply(Processor component, ReactiveProcessor next, ComponentLocation componentLocation, ProcessorInterceptor interceptor, Map<String, String> dslParameters) {
        if (this.implementsBeforeOrAfter(interceptor)) {
            LOGGER.debug("Configuring interceptor '{}' before and after processor '{}'...", (Object)interceptor, (Object)componentLocation.getLocation());
            return publisher -> Flux.from((Publisher)publisher).concatMap(event -> Flux.just((Object)event).cast(InternalEvent.class).map(this.doBefore(interceptor, component, dslParameters)).cast(CoreEvent.class).transform((Function)next).onErrorMap(MessagingException.class, error -> this.createMessagingException(this.doAfter(interceptor, component, Optional.of(error.getCause())).apply((InternalEvent)error.getEvent()), error.getCause(), (Component)component)).cast(InternalEvent.class).map(this.doAfter(interceptor, component, Optional.empty())));
        }
        return next;
    }

    private boolean implementsBeforeOrAfter(ProcessorInterceptor interceptor) {
        try {
            return !interceptor.getClass().getMethod(BEFORE_METHOD_NAME, ComponentLocation.class, Map.class, InterceptionEvent.class).isDefault() || !interceptor.getClass().getMethod(AFTER_METHOD_NAME, ComponentLocation.class, InterceptionEvent.class, Optional.class).isDefault();
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private Function<InternalEvent, InternalEvent> doBefore(ProcessorInterceptor interceptor, Processor component, Map<String, String> dslParameters) {
        return event -> {
            InternalEvent eventWithResolvedParams = this.addResolvedParameters((InternalEvent)event, component, dslParameters);
            DefaultInterceptionEvent interceptionEvent = new DefaultInterceptionEvent(eventWithResolvedParams);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Calling before() for '{}' in processor '{}'...", (Object)interceptor, (Object)((Component)component).getLocation().getLocation());
            }
            try {
                ClassUtils.withContextClassLoader(interceptor.getClass().getClassLoader(), () -> interceptor.before(((Component)component).getLocation(), this.getResolvedParams(eventWithResolvedParams), (InterceptionEvent)interceptionEvent));
                return interceptionEvent.resolve();
            }
            catch (Exception e) {
                throw Exceptions.propagate((Throwable)((Object)new MessagingException(interceptionEvent.resolve(), e.getCause(), (Component)component)));
            }
        };
    }

    protected Map<String, ProcessorParameterValue> getResolvedParams(InternalEvent eventWithResolvedParams) {
        return (Map)eventWithResolvedParams.getInternalParameters().get("core:interceptionResolvedParams");
    }

    private Function<InternalEvent, InternalEvent> doAfter(ProcessorInterceptor interceptor, Processor component, Optional<Throwable> thrown) {
        return event -> {
            InternalEvent eventWithResolvedParams = this.removeResolvedParameters((InternalEvent)event);
            DefaultInterceptionEvent interceptionEvent = new DefaultInterceptionEvent(eventWithResolvedParams);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Calling after() for '{}' in processor '{}'...", (Object)interceptor, (Object)((Component)component).getLocation().getLocation());
            }
            try {
                ClassUtils.withContextClassLoader(interceptor.getClass().getClassLoader(), () -> interceptor.after(((Component)component).getLocation(), (InterceptionEvent)interceptionEvent, thrown));
                return interceptionEvent.resolve();
            }
            catch (Exception e) {
                throw Exceptions.propagate((Throwable)((Object)this.createMessagingException(interceptionEvent.resolve(), e.getCause(), (Component)component)));
            }
        };
    }

    private boolean isInterceptable(Processor component) {
        return ((Component)component).getLocation() != null;
    }

    protected InternalEvent addResolvedParameters(InternalEvent event, Processor component, Map<String, String> dslParameters) {
        boolean sameComponent;
        boolean bl = sameComponent = this.internalParametersFrom(event).containsKey(INTERCEPTION_COMPONENT) ? component.equals(this.internalParametersFrom(event).get(INTERCEPTION_COMPONENT)) : false;
        if (!sameComponent || !this.internalParametersFrom(event).containsKey("core:interceptionResolvedParams")) {
            return this.resolveParameters(this.removeResolvedParameters(event), component, dslParameters);
        }
        return event;
    }

    private InternalEvent removeResolvedParameters(InternalEvent event) {
        Processor processor;
        if (this.internalParametersFrom(event).containsKey("core:interceptionResolvedContext") && (processor = (Processor)this.internalParametersFrom(event).get(INTERCEPTION_COMPONENT)) instanceof ParametersResolverProcessor) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Disposing resolved parameters for processor {}...", (Object)((Component)processor).getLocation().getLocation());
            }
            ((ParametersResolverProcessor)((Object)processor)).disposeResolvedParameters((ExecutionContext)this.internalParametersFrom(event).get("core:interceptionResolvedContext"));
        }
        return InternalEvent.builder(event).removeInternalParameter("core:interceptionResolvedParams").removeInternalParameter(INTERCEPTION_COMPONENT).removeInternalParameter("core:interceptionResolvedContext").build();
    }

    private Map<String, ?> internalParametersFrom(CoreEvent event) {
        return ((InternalEvent)event).getInternalParameters();
    }

    private InternalEvent resolveParameters(InternalEvent event, Processor processor, Map<String, String> parameters) {
        HashMap<String, DefaultProcessorParameterValue> resolvedParameters = new HashMap<String, DefaultProcessorParameterValue>();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            String providedValue = entry.getValue();
            resolvedParameters.put(entry.getKey(), new DefaultProcessorParameterValue(entry.getKey(), providedValue, () -> {
                if (this.expressionManager.isExpression(providedValue)) {
                    return this.expressionManager.evaluate(providedValue, (CoreEvent)event, ((Component)processor).getLocation()).getValue();
                }
                return String.valueOf(providedValue);
            }));
        }
        InternalEvent.Builder builder = InternalEvent.builder(event);
        if (processor instanceof ParametersResolverProcessor) {
            try {
                ((ParametersResolverProcessor)((Object)processor)).resolveParameters(builder, (params, context) -> {
                    resolvedParameters.putAll(params.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> new DefaultProcessorParameterValue((String)e.getKey(), null, () -> e.getValue()))));
                    HashMap<String, Object> interceptionEventParams = new HashMap<String, Object>();
                    interceptionEventParams.put("core:interceptionResolvedContext", context);
                    interceptionEventParams.put("core:interceptionResolvedParams", resolvedParameters);
                    interceptionEventParams.put(INTERCEPTION_COMPONENT, processor);
                    builder.internalParameters(interceptionEventParams);
                });
            }
            catch (MuleException e) {
                throw new InterceptionException(e);
            }
        } else {
            HashMap<String, Object> interceptionEventParams = new HashMap<String, Object>();
            interceptionEventParams.put("core:interceptionResolvedParams", resolvedParameters);
            interceptionEventParams.put(INTERCEPTION_COMPONENT, processor);
            builder.internalParameters(interceptionEventParams);
        }
        return builder.build();
    }

    protected MessagingException createMessagingException(CoreEvent event, Throwable cause, Component processor) {
        MessagingExceptionResolver exceptionResolver = new MessagingExceptionResolver(processor);
        MessagingException me = new MessagingException(event, cause, processor);
        return exceptionResolver.resolve(me, this.muleContext);
    }

    protected MuleContext getMuleContext() {
        return this.muleContext;
    }
}

