/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transformer.graph;

import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.collections.map.LRUMap;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.transformer.Converter;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.internal.registry.TransformerResolver;
import org.mule.runtime.core.internal.transformer.ResolverException;
import org.mule.runtime.core.internal.transformer.graph.CompositeConverterFilter;
import org.mule.runtime.core.internal.transformer.graph.NameConverterFilter;
import org.mule.runtime.core.internal.transformer.graph.PriorityWeightingConverterFilter;
import org.mule.runtime.core.internal.transformer.graph.TransformationGraph;
import org.mule.runtime.core.internal.transformer.graph.TransformationGraphLookupStrategy;
import org.mule.runtime.core.internal.transformer.graph.TransformationLengthConverterFilter;
import org.mule.runtime.core.internal.transformer.graph.TypeMatchingVertexesFilter;

public class GraphTransformerResolver
implements TransformerResolver {
    private ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private TransformationGraph graph = new TransformationGraph();
    private CompositeConverterFilter converterFilter;
    private LRUMap cache;
    private TransformationGraphLookupStrategy lookupStrategyTransformation = new TransformationGraphLookupStrategy(this.graph);

    public GraphTransformerResolver() {
        this.converterFilter = new CompositeConverterFilter(new TypeMatchingVertexesFilter(), new TransformationLengthConverterFilter(), new PriorityWeightingConverterFilter(), new NameConverterFilter());
        this.cache = new LRUMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Transformer resolve(DataType source, DataType result) throws ResolverException {
        String cacheKey = this.getDataTypeSourceResultPairHash(source, result);
        this.readWriteLock.readLock().lock();
        try {
            if (this.cache.containsKey((Object)cacheKey)) {
                Converter converter = (Converter)this.cache.get((Object)cacheKey);
                return converter;
            }
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
        List<Converter> converters = this.converterFilter.filter(this.lookupStrategyTransformation.lookupConverters(source, result), source, result);
        if (converters.size() > 1) {
            throw new ResolverException(CoreMessages.transformHasMultipleMatches(source.getType(), result.getType(), converters));
        }
        Transformer converter = converters.size() == 0 ? null : (Transformer)converters.get(0);
        this.readWriteLock.writeLock().lock();
        try {
            this.cache.put((Object)cacheKey, (Object)converter);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
        return converter;
    }

    private String getDataTypeSourceResultPairHash(DataType source, DataType result) {
        StringBuilder builder = new StringBuilder();
        builder.append(source.getClass().getName());
        builder.append(source.hashCode());
        builder.append(":");
        builder.append(result.getClass().getName());
        builder.append(result.hashCode());
        return builder.toString();
    }

    @Override
    public void transformerChange(Transformer transformer, TransformerResolver.RegistryAction registryAction) {
        this.readWriteLock.writeLock().lock();
        try {
            if (!(transformer instanceof Converter)) {
                return;
            }
            this.cache.clear();
            if (registryAction == TransformerResolver.RegistryAction.ADDED) {
                this.graph.addConverter((Converter)transformer);
            } else if (registryAction == TransformerResolver.RegistryAction.REMOVED) {
                this.graph.removeConverter((Converter)transformer);
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }
}

