/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.message;

import java.util.Collection;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.api.util.concurrent.FunctionalReadWriteLock;
import org.mule.runtime.core.internal.util.message.MessageUtils;
import org.mule.runtime.core.internal.util.message.ResultToMessageIterator;
import org.mule.runtime.extension.api.runtime.operation.Result;

abstract class ResultsToMessageCollection
implements Collection<Message> {
    private final Collection<Object> delegate;
    protected final CursorProviderFactory cursorProviderFactory;
    protected final CoreEvent event;
    protected final FunctionalReadWriteLock lock = FunctionalReadWriteLock.readWriteLock();

    public ResultsToMessageCollection(Collection<Object> delegate, CursorProviderFactory cursorProviderFactory, CoreEvent event) {
        this.delegate = delegate;
        this.cursorProviderFactory = cursorProviderFactory;
        this.event = event;
    }

    @Override
    public int size() {
        return this.lock.withReadLock(r -> this.delegate.size());
    }

    @Override
    public boolean isEmpty() {
        return this.lock.withReadLock(r -> this.delegate.isEmpty());
    }

    @Override
    public boolean contains(Object o) {
        return this.lock.withReadLock(r -> {
            boolean contains = this.delegate.contains(o);
            if (!contains && o instanceof Message) {
                contains = this.delegate.contains(Result.builder((Message)((Message)o)));
            }
            return contains;
        });
    }

    @Override
    public Iterator<Message> iterator() {
        return new ResultToMessageIterator(this.delegate.iterator(), this.cursorProviderFactory, this.event);
    }

    @Override
    public Object[] toArray() {
        return this.lock.withReadLock(r -> this.transformArray(this.delegate.toArray()));
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.lock.withReadLock(r -> this.transformArray(this.delegate.toArray(a)));
    }

    private <T> T[] transformArray(T[] array) {
        return Stream.of(array).map(result -> this.toMessage(result, this.cursorProviderFactory, this.event)).toArray(Object[]::new);
    }

    @Override
    public boolean add(Message message) {
        return this.lock.withWriteLock(() -> this.delegate.add(message));
    }

    @Override
    public boolean remove(Object o) {
        return this.lock.withWriteLock(() -> this.delegate.remove(o));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        return this.lock.withReadLock(r -> this.delegate.stream().allMatch(this.delegate::contains));
    }

    protected Collection<?> toResults(Collection<?> messages) {
        return messages.stream().map(o -> {
            if (o instanceof Message) {
                return o;
            }
            return this.toMessage(o, this.cursorProviderFactory, this.event);
        }).collect(Collectors.toList());
    }

    @Override
    public boolean addAll(Collection<? extends Message> c) {
        return this.lock.withWriteLock(() -> this.delegate.addAll(c));
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        return this.lock.withWriteLock(() -> {
            boolean removed = false;
            for (Object value : c) {
                boolean itemRemoved = this.delegate.remove(c);
                if (!itemRemoved) {
                    itemRemoved = this.delegate.remove(this.toMessage(value, this.cursorProviderFactory, this.event));
                }
                removed = removed || itemRemoved;
            }
            return removed;
        });
    }

    @Override
    public boolean removeIf(Predicate<? super Message> filter) {
        return this.delegate.removeIf((? super E result) -> filter.test(this.toMessage(result, this.cursorProviderFactory, this.event)));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.delegate.retainAll(this.toResults(c));
    }

    @Override
    public void clear() {
        this.lock.withWriteLock(this.delegate::clear);
    }

    @Override
    public boolean equals(Object o) {
        return this.lock.withReadLock(r -> this.delegate.equals(o));
    }

    @Override
    public int hashCode() {
        return this.lock.withReadLock(r -> this.delegate.hashCode());
    }

    @Override
    public Spliterator<Message> spliterator() {
        return this.delegate.stream().map(result -> this.toMessage(result, this.cursorProviderFactory, this.event)).collect(Collectors.toList()).spliterator();
    }

    @Override
    public Stream<Message> stream() {
        return this.delegate.stream().map(result -> this.toMessage(result, this.cursorProviderFactory, this.event));
    }

    @Override
    public Stream<Message> parallelStream() {
        return this.delegate.parallelStream().map(result -> this.toMessage(result, this.cursorProviderFactory, this.event));
    }

    @Override
    public void forEach(Consumer<? super Message> action) {
        this.stream().forEach(action);
    }

    protected Message toMessage(Object value, CursorProviderFactory cursorProviderFactory, CoreEvent event) {
        if (value instanceof Message) {
            return (Message)value;
        }
        return MessageUtils.toMessage((Result)value, cursorProviderFactory, event);
    }
}

