/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.objectbuilder;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.Predicate;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.module.extension.api.runtime.privileged.EventedExecutionContext;
import org.mule.runtime.module.extension.api.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.loader.ParameterGroupDescriptor;
import org.mule.runtime.module.extension.internal.loader.java.type.FieldElement;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.DefaultObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSetResult;
import org.mule.runtime.module.extension.internal.runtime.resolver.StaticValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;

public class ParameterGroupObjectBuilder<T>
extends DefaultObjectBuilder<T> {
    private final ParameterGroupDescriptor groupDescriptor;
    private final ConcurrentMap<Class<?>, List<FieldElement>> fieldsCache = new ConcurrentHashMap();

    public ParameterGroupObjectBuilder(ParameterGroupDescriptor groupDescriptor) {
        super(groupDescriptor.getType().getDeclaringClass());
        this.groupDescriptor = groupDescriptor;
    }

    public T build(EventedExecutionContext executionContext) throws MuleException {
        return this.doBuild(arg_0 -> ((EventedExecutionContext)executionContext).hasParameter(arg_0), arg_0 -> ((EventedExecutionContext)executionContext).getParameter(arg_0), ValueResolvingContext.from(executionContext.getEvent(), executionContext.getConfiguration()));
    }

    public T build(ResolverSetResult result) throws MuleException {
        Map<String, Object> resultMap = result.asMap();
        return this.doBuild(resultMap::containsKey, resultMap::get, ValueResolvingContext.from(MuleExtensionUtils.getInitialiserEvent()));
    }

    private T doBuild(Predicate<String> hasParameter, Function<String, Object> parameters, ValueResolvingContext context) throws MuleException {
        this.fieldsCache.computeIfAbsent(this.groupDescriptor.getType().getDeclaringClass(), k -> this.groupDescriptor.getType().getFields()).forEach(field -> {
            String name = field.getName();
            if (hasParameter.test(name)) {
                this.addPropertyResolver(name, new StaticValueResolver(parameters.apply(name)));
            }
        });
        return this.build(context);
    }
}

