/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.value;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Supplier;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.extension.api.values.ValueProvider;
import org.mule.runtime.module.extension.internal.loader.java.property.ValueProviderFactoryModelProperty;
import org.mule.runtime.module.extension.internal.runtime.ValueResolvingException;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParameterValueResolver;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.springframework.util.ReflectionUtils;

public class ValueProviderFactory {
    private final ValueProviderFactoryModelProperty factoryModelProperty;
    private final ParameterValueResolver parameterValueResolver;
    private final Supplier<Object> connectionSupplier;
    private final Supplier<Object> configurationSupplier;
    private final Field connectionField;
    private final Field configField;
    private final MuleContext muleContext;

    public ValueProviderFactory(ValueProviderFactoryModelProperty factoryModelProperty, ParameterValueResolver parameterValueResolver, Supplier<Object> connectionSupplier, Supplier<Object> configurationSupplier, Field connectionField, Field configField, MuleContext muleContext) {
        this.factoryModelProperty = factoryModelProperty;
        this.parameterValueResolver = parameterValueResolver;
        this.connectionSupplier = connectionSupplier;
        this.configurationSupplier = configurationSupplier;
        this.connectionField = connectionField;
        this.configField = configField;
        this.muleContext = muleContext;
    }

    ValueProvider createValueProvider() throws org.mule.runtime.extension.api.values.ValueResolvingException {
        Class<? extends ValueProvider> resolverClass = this.factoryModelProperty.getValueProvider();
        try {
            ValueProvider resolver = (ValueProvider)ClassUtils.instantiateClass(resolverClass, (Object[])new Object[0]);
            LifecycleUtils.initialiseIfNeeded((Object)resolver, (boolean)true, (MuleContext)this.muleContext);
            Optional<org.mule.runtime.extension.api.values.ValueResolvingException> optionalException = this.injectValueProviderFields(resolver);
            if (optionalException.isPresent()) {
                throw optionalException.get();
            }
            if (this.factoryModelProperty.usesConnection()) {
                ValueProviderFactory.injectValueIntoField(resolver, this.connectionSupplier.get(), this.connectionField);
            }
            if (this.factoryModelProperty.usesConfig()) {
                ValueProviderFactory.injectValueIntoField(resolver, this.configurationSupplier.get(), this.configField);
            }
            return resolver;
        }
        catch (org.mule.runtime.extension.api.values.ValueResolvingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new org.mule.runtime.extension.api.values.ValueResolvingException("An error occurred trying to create a ValueProvider", "UNKNOWN", (Throwable)e);
        }
    }

    private Optional<org.mule.runtime.extension.api.values.ValueResolvingException> injectValueProviderFields(ValueProvider resolver) throws ValueResolvingException {
        ArrayList<String> missingParameters = new ArrayList<String>();
        for (ValueProviderFactoryModelProperty.InjectableParameterInfo injectableParam : this.factoryModelProperty.getInjectableParameters()) {
            String parameterName = injectableParam.getParameterName();
            try {
                Object parameterValue = this.parameterValueResolver.getParameterValue(parameterName);
                ValueProviderFactory.injectValueIntoField(resolver, parameterValue, parameterName);
            }
            catch (ValueResolvingException e) {
                if (!injectableParam.isRequired()) continue;
                missingParameters.add(parameterName);
            }
        }
        return missingParameters.isEmpty() ? Optional.empty() : Optional.of(new org.mule.runtime.extension.api.values.ValueResolvingException("Unable to retrieve values. There are missing required parameters for the resolution: " + missingParameters, "MISSING_REQUIRED_PARAMETERS"));
    }

    private static void injectValueIntoField(ValueProvider fieldContainer, Object valueToInject, String requiredParamName) {
        Optional<Field> optionalField = IntrospectionUtils.getField(fieldContainer.getClass(), requiredParamName);
        if (optionalField.isPresent()) {
            Field field = optionalField.get();
            ValueProviderFactory.injectValueIntoField(fieldContainer, valueToInject, field);
        }
    }

    private static void injectValueIntoField(ValueProvider fieldContainer, Object valueToInject, Field field) {
        field.setAccessible(true);
        ReflectionUtils.setField((Field)field, (Object)fieldContainer, (Object)valueToInject);
    }
}

