/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Supplier;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Exceptions;
import reactor.core.Scannable;
import reactor.core.publisher.EventLoopProcessor;
import reactor.core.publisher.Flux;
import reactor.core.publisher.InnerProducer;
import reactor.core.publisher.Operators;
import reactor.core.publisher.RingBuffer;
import reactor.core.publisher.TopicProcessor;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.annotation.Nullable;
import reactor.util.concurrent.Queues;
import reactor.util.concurrent.WaitStrategy;

public final class WorkQueueProcessor<E>
extends EventLoopProcessor<E> {
    static final Supplier FACTORY = EventLoopProcessor.Slot::new;
    final RingBuffer.Sequence workSequence = RingBuffer.newSequence(-1L);
    final Queue<Object> claimedDisposed = new ConcurrentLinkedQueue<Object>();
    final WaitStrategy writeWait;
    volatile int replaying;
    static final AtomicIntegerFieldUpdater<WorkQueueProcessor> REPLAYING = AtomicIntegerFieldUpdater.newUpdater(WorkQueueProcessor.class, "replaying");
    static final Logger log = Loggers.getLogger(WorkQueueProcessor.class);

    public static final <T> Builder<T> builder() {
        return new Builder();
    }

    public static <E> WorkQueueProcessor<E> create() {
        return WorkQueueProcessor.builder().build();
    }

    public static <E> WorkQueueProcessor<E> create(String name, int bufferSize) {
        return WorkQueueProcessor.builder().name(name).bufferSize(bufferSize).build();
    }

    public static <E> WorkQueueProcessor<E> share(String name, int bufferSize) {
        return WorkQueueProcessor.builder().share(true).name(name).bufferSize(bufferSize).build();
    }

    WorkQueueProcessor(@Nullable ThreadFactory threadFactory, @Nullable ExecutorService executor, ExecutorService requestTaskExecutor, int bufferSize, WaitStrategy waitStrategy, boolean share, boolean autoCancel) {
        super(bufferSize, threadFactory, executor, requestTaskExecutor, autoCancel, share, FACTORY, waitStrategy);
        this.writeWait = waitStrategy;
        this.ringBuffer.addGatingSequence(this.workSequence);
    }

    @Override
    public void subscribe(CoreSubscriber<? super E> actual) {
        Objects.requireNonNull(actual, "subscribe");
        if (!this.alive()) {
            TopicProcessor.coldSource(this.ringBuffer, null, this.error, this.workSequence).subscribe(actual);
            return;
        }
        WorkQueueInner<? super E> signalProcessor = new WorkQueueInner<E>(actual, this);
        try {
            this.incrementSubscribers();
            signalProcessor.sequence.set(this.workSequence.getAsLong());
            this.ringBuffer.addGatingSequence(signalProcessor.sequence);
            int maxSubscribers = WorkQueueProcessor.bestEffortMaxSubscribers(this.executor);
            if (maxSubscribers > Integer.MIN_VALUE && this.subscriberCount > maxSubscribers) {
                throw new IllegalStateException("The executor service could not accommodate another subscriber, detected limit " + maxSubscribers);
            }
            this.executor.execute(signalProcessor);
        }
        catch (Throwable t) {
            this.decrementSubscribers();
            this.ringBuffer.removeGatingSequence(signalProcessor.sequence);
            if (RejectedExecutionException.class.isAssignableFrom(t.getClass())) {
                TopicProcessor.coldSource(this.ringBuffer, t, this.error, this.workSequence).subscribe(actual);
            }
            Operators.error(actual, t);
        }
    }

    static int bestEffortMaxSubscribers(ExecutorService executor) {
        int maxSubscribers = Integer.MIN_VALUE;
        if (executor instanceof ThreadPoolExecutor) {
            maxSubscribers = ((ThreadPoolExecutor)executor).getMaximumPoolSize();
        } else if (executor instanceof ForkJoinPool) {
            maxSubscribers = ((ForkJoinPool)executor).getParallelism();
        }
        return maxSubscribers;
    }

    @Override
    public Flux<E> drain() {
        return TopicProcessor.coldSource(this.ringBuffer, null, this.error, this.workSequence);
    }

    @Override
    protected void doError(Throwable t) {
        this.writeWait.signalAllWhenBlocking();
    }

    @Override
    protected void doComplete() {
        this.writeWait.signalAllWhenBlocking();
    }

    @Override
    protected void requestTask(Subscription s) {
        this.requestTaskExecutor.execute(WorkQueueProcessor.createRequestTask(s, this, null, this.ringBuffer::getMinimumGatingSequence));
    }

    @Override
    public long getPending() {
        return this.getBufferSize() - this.ringBuffer.getPending() + this.claimedDisposed.size();
    }

    @Override
    public void run() {
        if (!this.alive()) {
            WaitStrategy.alert();
        }
    }

    static final class WorkQueueInner<T>
    implements Runnable,
    InnerProducer<T> {
        final AtomicBoolean running = new AtomicBoolean(true);
        final RingBuffer.Sequence sequence = RingBuffer.newSequence(-1L);
        final RingBuffer.Sequence pendingRequest = RingBuffer.newSequence(0L);
        final RingBuffer.Reader barrier;
        final WorkQueueProcessor<T> processor;
        final CoreSubscriber<? super T> subscriber;
        final Runnable waiter = new Runnable(){

            @Override
            public void run() {
                if (barrier.isAlerted() || !this.isRunning() || this.replay(pendingRequest.getAsLong() == Long.MAX_VALUE)) {
                    WaitStrategy.alert();
                }
            }
        };

        WorkQueueInner(CoreSubscriber<? super T> subscriber, WorkQueueProcessor<T> processor) {
            this.processor = processor;
            this.subscriber = subscriber;
            this.barrier = processor.ringBuffer.newReader();
        }

        void halt() {
            this.running.set(false);
            this.barrier.alert();
        }

        boolean isRunning() {
            return this.running.get() && (this.processor.terminated == 0 || this.processor.error == null && this.processor.ringBuffer.getAsLong() > this.sequence.getAsLong());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block34: {
                processedSequence = true;
                try {
                    Thread.currentThread().setContextClassLoader(this.processor.contextClassLoader);
                    this.subscriber.onSubscribe(this);
                    cachedAvailableSequence = -9223372036854775808L;
                    nextSequence = this.sequence.getAsLong();
                    event = null;
                    if (!EventLoopProcessor.waitRequestOrTerminalEvent(this.pendingRequest, this.barrier, this.running, this.sequence, this.waiter)) {
                        if (!this.running.get()) {
                            return;
                        }
                        if (this.processor.terminated == 1 && this.processor.ringBuffer.getAsLong() == -1L) {
                            if (this.processor.error != null) {
                                this.subscriber.onError(this.processor.error);
                                return;
                            }
                            this.subscriber.onComplete();
                            return;
                        }
                    }
                    v0 = unbounded = this.pendingRequest.getAsLong() == 0x7FFFFFFFFFFFFFFFL;
                    if (this.replay(unbounded)) {
                        this.running.set(false);
                        return;
                    }
                    while (true) {
                        try {
                            while (true) {
                                if (processedSequence) {
                                    if (!this.running.get()) {
                                        break block34;
                                    }
                                    processedSequence = false;
                                    do {
                                        nextSequence = this.processor.workSequence.getAsLong() + 1L;
                                        while (!unbounded && this.pendingRequest.getAsLong() == 0L) {
                                            if (!this.isRunning()) {
                                                WaitStrategy.alert();
                                            }
                                            LockSupport.parkNanos(1L);
                                        }
                                        this.sequence.set(nextSequence - 1L);
                                    } while (!this.processor.workSequence.compareAndSet(nextSequence - 1L, nextSequence));
                                }
                                if (cachedAvailableSequence >= nextSequence) {
                                    event = (EventLoopProcessor.Slot)this.processor.ringBuffer.get(nextSequence);
                                    try {
                                        this.readNextEvent(unbounded);
                                    }
                                    catch (Exception ce) {
                                        if (!this.running.get() || !WaitStrategy.isAlert(ce)) {
                                            throw ce;
                                        }
                                        this.barrier.clearAlert();
                                    }
                                    processedSequence = true;
                                    this.subscriber.onNext(event.value);
                                    continue;
                                }
                                this.processor.readWait.signalAllWhenBlocking();
                                cachedAvailableSequence = this.barrier.waitFor(nextSequence, this.waiter);
                            }
                        }
                        catch (InterruptedException | RuntimeException ce) {
                            if (Exceptions.isCancel(ce)) {
                                this.reschedule(event);
                            } else {
                                if (!WaitStrategy.isAlert(ce)) {
                                    throw Exceptions.propagate(ce);
                                }
                                this.barrier.clearAlert();
                                if (!this.running.get()) {
                                } else {
                                    if (this.processor.terminated != 1) continue;
                                    if (this.processor.error != null) {
                                        processedSequence = true;
                                        this.subscriber.onError(this.processor.error);
                                    } else {
                                        if (this.processor.ringBuffer.getPending() == 0) ** break;
                                        continue;
                                        processedSequence = true;
                                        this.subscriber.onComplete();
                                    }
                                }
                            }
                        }
                        break;
                    }
                }
                finally {
                    this.processor.decrementSubscribers();
                    this.running.set(false);
                    if (!processedSequence) {
                        this.processor.claimedDisposed.add(this.sequence);
                    } else {
                        this.processor.ringBuffer.removeGatingSequence(this.sequence);
                    }
                    this.processor.writeWait.signalAllWhenBlocking();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        boolean replay(boolean unbounded) {
            block16: {
                if (!WorkQueueProcessor.REPLAYING.compareAndSet(this.processor, 0, 1)) break block16;
                try {
                    s = null;
                    while (true) {
                        if (!this.running.get()) {
                            this.processor.readWait.signalAllWhenBlocking();
                            var3_6 = true;
                            return var3_6;
                        }
                        v = this.processor.claimedDisposed.peek();
                        if (v == null) {
                            this.processor.readWait.signalAllWhenBlocking();
                            var4_10 = this.processor.alive() == false && this.processor.ringBuffer.getPending() == 0;
                            return var4_10;
                        }
                        if (!(v instanceof RingBuffer.Sequence)) ** GOTO lbl32
                        s = (RingBuffer.Sequence)v;
                        cursor = s.getAsLong() + 1L;
                        if (cursor > this.processor.ringBuffer.getAsLong()) {
                            this.processor.readWait.signalAllWhenBlocking();
                            var6_11 = this.processor.alive() == false && this.processor.ringBuffer.getPending() == 0;
                            return var6_11;
                        }
                        this.barrier.waitFor(cursor, this.waiter);
                        v = ((EventLoopProcessor.Slot)this.processor.ringBuffer.get((long)cursor)).value;
                        if (v == null) {
                            this.processor.ringBuffer.removeGatingSequence(s);
                            this.processor.claimedDisposed.poll();
                            s = null;
                            continue;
                        }
lbl32:
                        // 3 sources

                        this.readNextEvent(unbounded);
                        this.subscriber.onNext(v);
                        this.processor.claimedDisposed.poll();
                        if (s == null) continue;
                        this.processor.ringBuffer.removeGatingSequence(s);
                        s = null;
                        continue;
                        break;
                    }
                    catch (RuntimeException ce) {
                        if (!this.running.get() || Exceptions.isCancel(ce)) {
                            this.running.set(false);
                            var3_7 = true;
                            return var3_7;
                        }
                        throw ce;
                    }
                    catch (InterruptedException e) {
                        this.running.set(false);
                        var3_8 = true;
                        return var3_8;
                    }
                }
                finally {
                    WorkQueueProcessor.REPLAYING.compareAndSet(this.processor, 1, 0);
                }
            }
            return this.processor.alive() == false && this.processor.ringBuffer.getPending() == 0;
        }

        boolean reschedule(@Nullable EventLoopProcessor.Slot<T> event) {
            if (event != null && event.value != null) {
                this.processor.claimedDisposed.add(event.value);
                this.barrier.alert();
                this.processor.readWait.signalAllWhenBlocking();
                return true;
            }
            return false;
        }

        void readNextEvent(boolean unbounded) {
            while (!unbounded && EventLoopProcessor.getAndSub(this.pendingRequest, 1L) == 0L) {
                if (!this.isRunning()) {
                    WaitStrategy.alert();
                }
                LockSupport.parkNanos(1L);
            }
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.processor;
            }
            if (key == Scannable.Attr.PREFETCH) {
                return Integer.MAX_VALUE;
            }
            if (key == Scannable.Attr.TERMINATED) {
                return this.processor.isTerminated();
            }
            if (key == Scannable.Attr.CANCELLED) {
                return !this.running.get();
            }
            if (key == Scannable.Attr.REQUESTED_FROM_DOWNSTREAM) {
                return this.pendingRequest.getAsLong();
            }
            return InnerProducer.super.scanUnsafe(key);
        }

        @Override
        public CoreSubscriber<? super T> actual() {
            return this.subscriber;
        }

        public void request(long n) {
            if (!Operators.validate(n) || !this.running.get()) {
                return;
            }
            EventLoopProcessor.addCap(this.pendingRequest, n);
        }

        public void cancel() {
            this.halt();
        }
    }

    public static final class Builder<T> {
        String name;
        ExecutorService executor;
        ExecutorService requestTaskExecutor;
        int bufferSize = Queues.SMALL_BUFFER_SIZE;
        WaitStrategy waitStrategy;
        boolean share = false;
        boolean autoCancel = true;

        Builder() {
        }

        public Builder<T> name(@Nullable String name) {
            if (this.executor != null) {
                throw new IllegalArgumentException("Executor service is configured, name will not be used.");
            }
            this.name = name;
            return this;
        }

        public Builder<T> bufferSize(int bufferSize) {
            if (!Queues.isPowerOfTwo(bufferSize)) {
                throw new IllegalArgumentException("bufferSize must be a power of 2 : " + bufferSize);
            }
            if (bufferSize < 1) {
                throw new IllegalArgumentException("bufferSize must be strictly positive, was: " + bufferSize);
            }
            this.bufferSize = bufferSize;
            return this;
        }

        public Builder<T> waitStrategy(@Nullable WaitStrategy waitStrategy) {
            this.waitStrategy = waitStrategy;
            return this;
        }

        public Builder<T> autoCancel(boolean autoCancel) {
            this.autoCancel = autoCancel;
            return this;
        }

        public Builder<T> executor(@Nullable ExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public Builder<T> requestTaskExecutor(@Nullable ExecutorService requestTaskExecutor) {
            this.requestTaskExecutor = requestTaskExecutor;
            return this;
        }

        public Builder<T> share(boolean share) {
            this.share = share;
            return this;
        }

        public WorkQueueProcessor<T> build() {
            String name = this.name != null ? this.name : WorkQueueProcessor.class.getSimpleName();
            WaitStrategy waitStrategy = this.waitStrategy != null ? this.waitStrategy : WaitStrategy.liteBlocking();
            EventLoopProcessor.EventLoopFactory threadFactory = this.executor != null ? null : new EventLoopProcessor.EventLoopFactory(name, this.autoCancel);
            ExecutorService requestTaskExecutor = this.requestTaskExecutor != null ? this.requestTaskExecutor : EventLoopProcessor.defaultRequestTaskExecutor(EventLoopProcessor.defaultName(threadFactory, WorkQueueProcessor.class));
            return new WorkQueueProcessor(threadFactory, this.executor, requestTaskExecutor, this.bufferSize, waitStrategy, this.share, this.autoCancel);
        }
    }
}

