/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.soap.internal.runtime.connection;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.extension.api.soap.MessageDispatcherProvider;
import org.mule.runtime.extension.api.soap.SoapServiceProvider;
import org.mule.runtime.extension.api.soap.WebServiceDefinition;
import org.mule.runtime.extension.api.soap.message.MessageDispatcher;
import org.mule.runtime.soap.api.SoapService;
import org.mule.runtime.soap.api.client.SoapClient;
import org.mule.runtime.soap.api.client.SoapClientConfiguration;
import org.mule.runtime.soap.api.client.SoapClientConfigurationBuilder;
import org.mule.runtime.soap.api.client.SoapClientFactory;

public class ForwardingSoapClient {
    private final LoadingCache<WebServiceDefinition, SoapClient> clientsCache;
    private final MessageDispatcherProvider<MessageDispatcher> dispatcherProvider;
    private final SoapServiceProvider serviceProvider;
    private final List<WebServiceDefinition> webServiceDefinitions;

    ForwardingSoapClient(SoapService service, SoapServiceProvider serviceProvider, MessageDispatcherProvider<MessageDispatcher> dispatcherProvider) {
        this.serviceProvider = serviceProvider;
        this.webServiceDefinitions = serviceProvider.getWebServiceDefinitions();
        this.dispatcherProvider = dispatcherProvider;
        this.clientsCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).removalListener((RemovalListener)new ForwardingClientRemovalListener()).build((CacheLoader)new SoapClientCacheLoader(service));
    }

    public Map<String, String> getCustomHeaders(String id, String operation) {
        Map<String, String> customHeaders = this.serviceProvider.getCustomHeaders(this.getWebServiceDefinitionById(id), operation);
        return customHeaders != null ? customHeaders : Collections.emptyMap();
    }

    public SoapClient getSoapClient(String id) {
        try {
            return (SoapClient)this.clientsCache.get((Object)this.getWebServiceDefinitionById(id));
        }
        catch (ExecutionException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Error while retrieving soap client id [" + id + "]")), (Throwable)e);
        }
    }

    private WebServiceDefinition getWebServiceDefinitionById(String id) {
        return this.webServiceDefinitions.stream().filter(ws -> ws.getServiceId().equals(id)).findAny().orElseThrow(() -> new IllegalArgumentException("Could not find a web service definition with id=[" + id + "]"));
    }

    public List<WebServiceDefinition> getAllWebServices() {
        return ImmutableList.copyOf(this.webServiceDefinitions);
    }

    public void disconnect() {
        this.clientsCache.invalidateAll();
    }

    private class ForwardingClientRemovalListener
    implements RemovalListener<WebServiceDefinition, SoapClient> {
        private ForwardingClientRemovalListener() {
        }

        public void onRemoval(RemovalNotification<WebServiceDefinition, SoapClient> notification) {
            SoapClient client = (SoapClient)notification.getValue();
            try {
                if (client != null) {
                    client.stop();
                }
            }
            catch (Exception e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"A problem occurred while disconnecting client: '%s'", (Object[])new Object[]{client}), (Throwable)e);
            }
        }
    }

    private class SoapClientCacheLoader
    extends CacheLoader<WebServiceDefinition, SoapClient> {
        private final SoapService service;

        private SoapClientCacheLoader(SoapService service) {
            this.service = service;
        }

        public SoapClient load(WebServiceDefinition definition) throws Exception {
            SoapClientFactory clientFactory = this.service.getClientFactory();
            SoapClientConfigurationBuilder configurationBuilder = SoapClientConfiguration.builder().withService(definition.getService()).withDispatcher((MessageDispatcher)ForwardingSoapClient.this.dispatcherProvider.connect()).withPort(definition.getPort()).withWsdlLocation(definition.getWsdlUrl().toString());
            if (definition.getAddress() != null) {
                configurationBuilder.withAddress(definition.getAddress().toString());
            }
            ForwardingSoapClient.this.serviceProvider.getSecurities().forEach(arg_0 -> ((SoapClientConfigurationBuilder)configurationBuilder).withSecurity(arg_0));
            SoapClient soapClient = clientFactory.create(configurationBuilder.build());
            soapClient.start();
            return soapClient;
        }
    }
}

