/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.java.api.utils;

import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.ClassUtils;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.annotation.EnumAnnotation;
import org.mule.metadata.api.annotation.IntAnnotation;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.model.AnyType;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.BooleanType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NullType;
import org.mule.metadata.api.model.NumberType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.model.VoidType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;

public final class JavaTypeUtils {
    private JavaTypeUtils() {
    }

    public static Optional<String> getId(final MetadataType metadataType) {
        Optional id = MetadataTypeUtils.getTypeId((MetadataType)metadataType);
        if (id.isPresent()) {
            return id;
        }
        MetadataTypeUtils.TypeResolverVisitor visitor = new MetadataTypeUtils.TypeResolverVisitor(){

            public void defaultVisit(MetadataType metadataType2) {
                this.typeId = this.fromClassInfo(metadataType2);
            }

            public void visitAnyType(AnyType anyType) {
                this.typeId = Object.class.getName();
            }

            public void visitBoolean(BooleanType booleanType) {
                this.typeId = this.fromClassInfo(metadataType);
                if (this.typeId == null) {
                    this.typeId = Boolean.TYPE.getName();
                }
            }

            public void visitNumber(NumberType numberType) {
                this.defaultVisit((MetadataType)numberType);
                if (this.typeId == null) {
                    this.typeId = numberType.getAnnotation(IntAnnotation.class).map(a -> Integer.class.getName()).orElse(null);
                }
            }

            public void visitObject(ObjectType objectType) {
                this.typeId = this.getTypeId((MetadataType)objectType);
                if (this.typeId == null) {
                    this.defaultVisit((MetadataType)objectType);
                }
            }

            public void visitString(StringType stringType) {
                if (stringType.getAnnotation(EnumAnnotation.class).isPresent()) {
                    this.typeId = this.getTypeId((MetadataType)stringType);
                }
                if (this.typeId == null) {
                    this.typeId = String.class.getName();
                }
            }

            public void visitArrayType(ArrayType arrayType) {
                this.typeId = this.fromClassInfo((MetadataType)arrayType);
                if (this.typeId == null) {
                    this.typeId = List.class.getName();
                }
            }

            private String fromClassInfo(MetadataType type) {
                return type.getAnnotation(ClassInformationAnnotation.class).map(ClassInformationAnnotation::getClassname).orElse(null);
            }

            private String getTypeId(MetadataType type) {
                return type.getAnnotation(TypeIdAnnotation.class).map(TypeIdAnnotation::getValue).orElse(null);
            }
        };
        metadataType.accept((MetadataTypeVisitor)visitor);
        return Optional.ofNullable(visitor.getResolvedTypeId());
    }

    public static <T> Class<T> getType(MetadataType metadataType) {
        return JavaTypeUtils.getType(metadataType, Thread.currentThread().getContextClassLoader());
    }

    public static <T> Class<T> getType(MetadataType metadataType, ClassLoader classLoader) {
        if (metadataType instanceof NullType || metadataType instanceof VoidType) {
            return Void.TYPE;
        }
        return JavaTypeUtils.getId(metadataType).map(id -> {
            try {
                return ClassUtils.getClass((ClassLoader)classLoader, (String)id, (boolean)true);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Could not load class " + id, e);
            }
        }).orElseThrow(() -> new IllegalArgumentException("MetadataType does not contain class information"));
    }

    public static Optional<MetadataType> getGenericTypeAt(MetadataType metadataType, int index, ClassTypeLoader typeLoader) {
        Optional classInformationAnnotation = metadataType.getAnnotation(ClassInformationAnnotation.class);
        if (!classInformationAnnotation.isPresent() || ((ClassInformationAnnotation)classInformationAnnotation.get()).getGenericTypes().size() <= index) {
            return Optional.empty();
        }
        return typeLoader.load(((ClassInformationAnnotation)classInformationAnnotation.get()).getGenericTypes().get(index));
    }
}

