/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.management.stats;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.mule.runtime.core.api.management.stats.FlowConstructStatistics;
import org.mule.runtime.core.internal.management.stats.ApplicationStatistics;

public class AllStatistics {
    private boolean isStatisticsEnabled;
    private long startTime;
    private ApplicationStatistics appStats;
    private Map<String, FlowConstructStatistics> flowConstructStats = new HashMap<String, FlowConstructStatistics>();

    public AllStatistics() {
        this.clear();
        this.appStats = new ApplicationStatistics(this);
        this.appStats.setEnabled(this.isStatisticsEnabled);
        this.add(this.appStats);
    }

    public synchronized void clear() {
        for (FlowConstructStatistics statistics : this.getServiceStatistics()) {
            statistics.clear();
        }
        this.startTime = System.currentTimeMillis();
    }

    public boolean isEnabled() {
        return this.isStatisticsEnabled;
    }

    public void setEnabled(boolean b) {
        this.isStatisticsEnabled = b;
        for (FlowConstructStatistics statistics : this.flowConstructStats.values()) {
            statistics.setEnabled(b);
        }
    }

    public synchronized long getStartTime() {
        return this.startTime;
    }

    public synchronized void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public synchronized void add(FlowConstructStatistics stat) {
        if (stat != null) {
            this.flowConstructStats.put(stat.getName(), stat);
        }
    }

    public synchronized void remove(FlowConstructStatistics stat) {
        if (stat != null) {
            this.flowConstructStats.remove(stat.getName());
        }
    }

    public synchronized Collection<FlowConstructStatistics> getServiceStatistics() {
        return this.flowConstructStats.values();
    }

    public FlowConstructStatistics getApplicationStatistics() {
        return this.appStats;
    }
}

