/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal.executor;

import java.util.Collections;
import java.util.Set;

public abstract class AbstractByCallerPolicy {
    private final Set<ThreadGroup> waitGroups;
    private final ThreadGroup parentGroup;

    protected AbstractByCallerPolicy(Set<ThreadGroup> waitGroups, ThreadGroup parentGroup) {
        this.waitGroups = Collections.unmodifiableSet(waitGroups);
        this.parentGroup = parentGroup;
    }

    protected boolean isWaitGroupThread(ThreadGroup threadGroup) {
        if (threadGroup != null) {
            while (threadGroup.getParent() != null) {
                if (this.waitGroups.contains(threadGroup)) {
                    return true;
                }
                threadGroup = threadGroup.getParent();
            }
        }
        return false;
    }

    protected boolean isSchedulerThread(ThreadGroup threadGroup) {
        if (threadGroup != null) {
            while (threadGroup.getParent() != null) {
                if (threadGroup.equals(this.parentGroup)) {
                    return true;
                }
                threadGroup = threadGroup.getParent();
            }
        }
        return false;
    }
}

