/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.container.api;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.LinkedList;
import org.mule.runtime.api.util.Preconditions;

public abstract class MetadataInvocationHandler<T>
implements InvocationHandler {
    private final T innerObject;

    protected MetadataInvocationHandler(T innerObject) {
        Preconditions.checkArgument((innerObject != null ? 1 : 0) != 0, (String)"object cannot be null");
        this.innerObject = innerObject;
    }

    protected Method[] getImplementationDeclaredMethods() {
        if (this.isNestedProxy()) {
            return ((MetadataInvocationHandler)Proxy.getInvocationHandler(this.getProxiedObject())).getImplementationDeclaredMethods();
        }
        LinkedList<Method> methods = new LinkedList<Method>();
        for (Class<?> clazz = this.getProxiedObject().getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            methods.addAll(Arrays.asList(clazz.getDeclaredMethods()));
        }
        return methods.toArray(new Method[methods.size()]);
    }

    protected Object doInvoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.isNestedProxy()) {
            return Proxy.getInvocationHandler(this.getProxiedObject()).invoke(this.getProxiedObject(), method, args);
        }
        try {
            return method.invoke(this.getProxiedObject(), args);
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
    }

    protected T getProxiedObject() {
        return this.innerObject;
    }

    private boolean isNestedProxy() {
        return Proxy.isProxyClass(this.getProxiedObject().getClass()) && Proxy.getInvocationHandler(this.getProxiedObject()) instanceof MetadataInvocationHandler;
    }
}

