/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.model.parameter;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.meta.model.parameter.ValueProviderModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.extension.api.model.AbstractNamedImmutableModel;

public final class ImmutableParameterModel
extends AbstractNamedImmutableModel
implements ParameterModel {
    private final MetadataType type;
    private final boolean hasDynamicType;
    private final boolean required;
    private final boolean isConfigOverride;
    private final ValueProviderModel valueProviderModel;
    private final ExpressionSupport expressionSupport;
    private final Object defaultValue;
    private final ParameterRole role;
    private final ParameterDslConfiguration dslConfiguration;
    private final LayoutModel layoutModel;
    private final List<StereotypeModel> allowedStereotypeModels;

    public ImmutableParameterModel(String name, String description, MetadataType type, boolean hasDynamicType, boolean required, boolean isConfigOverride, ExpressionSupport expressionSupport, Object defaultValue, ParameterRole role, ParameterDslConfiguration dslConfiguration, DisplayModel displayModel, LayoutModel layoutModel, ValueProviderModel valueProviderModel, List<StereotypeModel> allowedStereotypeModels, Set<ModelProperty> modelProperties) {
        super(name, description, displayModel, modelProperties);
        this.type = type;
        this.required = required;
        this.expressionSupport = expressionSupport;
        this.defaultValue = defaultValue;
        this.role = role;
        this.hasDynamicType = hasDynamicType;
        this.dslConfiguration = dslConfiguration;
        this.layoutModel = layoutModel;
        this.isConfigOverride = isConfigOverride;
        this.valueProviderModel = valueProviderModel;
        this.allowedStereotypeModels = Collections.unmodifiableList(allowedStereotypeModels);
    }

    public MetadataType getType() {
        return this.type;
    }

    public boolean hasDynamicType() {
        return this.hasDynamicType;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isOverrideFromConfig() {
        return this.isConfigOverride;
    }

    public ExpressionSupport getExpressionSupport() {
        return this.expressionSupport;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public ParameterDslConfiguration getDslConfiguration() {
        return this.dslConfiguration;
    }

    public ParameterRole getRole() {
        return this.role;
    }

    public Optional<LayoutModel> getLayoutModel() {
        return Optional.ofNullable(this.layoutModel);
    }

    public List<StereotypeModel> getAllowedStereotypes() {
        return this.allowedStereotypeModels;
    }

    public Optional<ValueProviderModel> getValueProviderModel() {
        return Optional.ofNullable(this.valueProviderModel);
    }
}

