/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.policy;

import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.policy.Policy;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public abstract class AbstractCompositePolicy<ParametersTransformer, ParametersProcessor> {
    private final List<Policy> parameterizedPolicies;
    private final Optional<ParametersTransformer> parametersTransformer;
    private final ParametersProcessor parametersProcessor;

    public AbstractCompositePolicy(List<Policy> policies, Optional<ParametersTransformer> parametersTransformer, ParametersProcessor parametersProcessor) {
        Preconditions.checkArgument((!policies.isEmpty() ? 1 : 0) != 0, (String)"policies list cannot be empty");
        this.parameterizedPolicies = policies;
        this.parametersTransformer = parametersTransformer;
        this.parametersProcessor = parametersProcessor;
    }

    public final ReactiveProcessor getPolicyProcessor() {
        return new NextOperationCall();
    }

    protected Optional<ParametersTransformer> getParametersTransformer() {
        return this.parametersTransformer;
    }

    protected ParametersProcessor getParametersProcessor() {
        return this.parametersProcessor;
    }

    protected abstract Publisher<CoreEvent> processNextOperation(CoreEvent var1);

    protected abstract Publisher<CoreEvent> processPolicy(Policy var1, Processor var2, CoreEvent var3);

    public class NextOperationCall
    extends AbstractComponent
    implements Processor {
        private int index = 0;

        @Override
        public CoreEvent process(CoreEvent event) throws MuleException {
            return MessageProcessors.processToApply(event, this);
        }

        @Override
        public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
            return Mono.from(publisher).flatMap(event -> {
                Preconditions.checkState((this.index <= AbstractCompositePolicy.this.parameterizedPolicies.size() ? 1 : 0) != 0, (String)"composite policy index is greater that the number of policies.");
                if (this.index == AbstractCompositePolicy.this.parameterizedPolicies.size()) {
                    return Mono.from(AbstractCompositePolicy.this.processNextOperation((CoreEvent)event));
                }
                return Mono.from(AbstractCompositePolicy.this.processPolicy((Policy)AbstractCompositePolicy.this.parameterizedPolicies.get(this.index++), this, (CoreEvent)event));
            }).onErrorMap(throwable -> !(throwable instanceof MuleException), throwable -> new DefaultMuleException(throwable));
        }
    }
}

