/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.strategy;

import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Supplier;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.internal.processor.strategy.AbstractStreamProcessingStrategyFactory;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;

public class ReactorStreamProcessingStrategyFactory
extends AbstractStreamProcessingStrategyFactory {
    @Override
    public ProcessingStrategy create(MuleContext muleContext, String schedulersNamePrefix) {
        return new ReactorStreamProcessingStrategy(this.getRingBufferSchedulerSupplier(muleContext, schedulersNamePrefix), this.getBufferSize(), this.getSubscriberCount(), this.getWaitStrategy(), this.getCpuLightSchedulerSupplier(muleContext, schedulersNamePrefix), this.resolveParallelism(), this.getMaxConcurrency());
    }

    protected int resolveParallelism() {
        if (this.getMaxConcurrency() == Integer.MAX_VALUE) {
            return Math.max(CORES / this.getSubscriberCount(), 1);
        }
        return Math.min(CORES, Math.max(this.getMaxConcurrency() / this.getSubscriberCount(), 1));
    }

    protected Supplier<Scheduler> getCpuLightSchedulerSupplier(MuleContext muleContext, String schedulersNamePrefix) {
        return () -> muleContext.getSchedulerService().cpuLightScheduler(muleContext.getSchedulerBaseConfig().withName(schedulersNamePrefix + "." + ReactiveProcessor.ProcessingType.CPU_LITE.name()));
    }

    @Override
    public Class<? extends ProcessingStrategy> getProcessingStrategyType() {
        return ReactorStreamProcessingStrategy.class;
    }

    static class ReactorStreamProcessingStrategy
    extends AbstractStreamProcessingStrategyFactory.AbstractStreamProcessingStrategy
    implements Startable,
    Stoppable {
        private Supplier<Scheduler> cpuLightSchedulerSupplier;
        private Scheduler cpuLightScheduler;
        private int parallelism;

        ReactorStreamProcessingStrategy(Supplier<Scheduler> ringBufferSchedulerSupplier, int bufferSize, int subscribers, String waitStrategy, Supplier<Scheduler> cpuLightSchedulerSupplier, int parallelism, int maxConcurrency) {
            super(ringBufferSchedulerSupplier, bufferSize, subscribers, waitStrategy, maxConcurrency);
            this.cpuLightSchedulerSupplier = cpuLightSchedulerSupplier;
            this.parallelism = parallelism;
        }

        @Override
        public ReactiveProcessor onPipeline(ReactiveProcessor pipeline) {
            if (this.maxConcurrency > this.subscribers) {
                return publisher -> Flux.from((Publisher)publisher).parallel(this.parallelism).runOn(Schedulers.fromExecutorService((ExecutorService)this.decorateScheduler(this.getCpuLightScheduler()))).composeGroup((Function)pipeline);
            }
            return super.onPipeline(pipeline);
        }

        @Override
        public ReactiveProcessor onProcessor(ReactiveProcessor processor) {
            if (processor.getProcessingType() == ReactiveProcessor.ProcessingType.CPU_LITE_ASYNC) {
                return publisher -> Flux.from((Publisher)publisher).transform((Function)processor).parallel(this.parallelism).runOn(Schedulers.fromExecutorService((ExecutorService)this.decorateScheduler(this.getCpuLightScheduler())));
            }
            return super.onProcessor(processor);
        }

        protected int getParallelism() {
            return this.parallelism;
        }

        public void start() throws MuleException {
            this.cpuLightScheduler = this.cpuLightSchedulerSupplier.get();
        }

        public void stop() throws MuleException {
            if (this.cpuLightScheduler != null) {
                this.cpuLightScheduler.stop();
            }
        }

        protected Scheduler getCpuLightScheduler() {
            return this.cpuLightScheduler;
        }
    }
}

